/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.progress;

import com.schneide.base.datetime.Time;
import com.schneide.base.i18n.NotI18NYet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractDelay
implements BoundedRangeModel {
    private final List<ChangeListener> changeListenerList = new ArrayList<ChangeListener>();
    private final ChangeEvent changeEvent;
    private final String title;
    private final String description;
    private final long startTime;
    private boolean canEstimateTime;
    private boolean canShowTime;
    private boolean canGiveTextualProgress;
    private boolean canAutoDispose;
    private boolean isAdjusting;
    private int minimalValue = -1;
    private int maximalValue = 100;
    private int actualValue = -1;
    private boolean isFinished;

    protected AbstractDelay(String title, String description) {
        this(title, description, false, false, false, true);
    }

    protected AbstractDelay(String title, String description, boolean canEstimateTime, boolean canShowTime, boolean canGiveTextualProgress, boolean canAutoDispose) {
        this.title = title;
        this.description = description;
        this.startTime = System.currentTimeMillis();
        this.changeEvent = new ChangeEvent(this);
        this.canEstimateTime = canEstimateTime;
        this.canShowTime = canShowTime;
        this.canGiveTextualProgress = canGiveTextualProgress;
        this.canAutoDispose = canAutoDispose;
        this.isAdjusting = false;
        this.isFinished = false;
    }

    public String getDescription() {
        return this.description;
    }

    public BoundedRangeModel getSpinnerModel() {
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public abstract String getProgressText();

    public String getElapsedTimeText() {
        return new NotI18NYet("Bisherige Laufzeit: {0}", new Object[]{Time.formatTimeInMilliseconds((long)this.getDuration())}).resolvedText();
    }

    private long getDuration() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getEstimatedTimeText() {
        double duration = this.getDuration();
        double totalDuration = duration / this.getProcessedPercentage();
        return new NotI18NYet("Restlaufzeit: {0}", new Object[]{Time.formatTimeInMilliseconds((long)((long)(totalDuration - duration)))}).resolvedText();
    }

    public double getProcessedPercentage() {
        int range = this.getMaximum() - this.getMinimum();
        if (range > 0) {
            double value = this.getValue() - this.getMinimum();
            return value / (double)range;
        }
        return 1.0;
    }

    @Override
    public int getExtent() {
        return 0;
    }

    @Override
    public void setExtent(int arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ChangeListener arg0) {
        if (arg0 != null) {
            List<ChangeListener> list = this.changeListenerList;
            synchronized (list) {
                this.changeListenerList.add(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void valueChanged() {
        List<ChangeListener> list = this.changeListenerList;
        synchronized (list) {
            Iterator<ChangeListener> iterator = this.changeListenerList.iterator();
            while (iterator.hasNext()) {
                ChangeListener element0;
                ChangeListener element = element0 = iterator.next();
                element.stateChanged(this.changeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ChangeListener arg0) {
        if (arg0 != null) {
            List<ChangeListener> list = this.changeListenerList;
            synchronized (list) {
                this.changeListenerList.remove(arg0);
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean arg0) {
        this.isAdjusting = arg0;
    }

    @Override
    public int getMaximum() {
        return this.maximalValue;
    }

    @Override
    public int getMinimum() {
        return this.minimalValue;
    }

    @Override
    public int getValue() {
        return this.actualValue;
    }

    @Override
    public void setMaximum(int arg0) {
        this.setRangeProperties(this.actualValue, 0, this.minimalValue, arg0, this.isAdjusting);
    }

    @Override
    public void setMinimum(int arg0) {
        this.setRangeProperties(this.actualValue, 0, arg0, this.maximalValue, this.isAdjusting);
    }

    @Override
    public void setRangeProperties(int actual, int extent, int min, int max, boolean arg4) {
        boolean isChange;
        this.setValueIsAdjusting(arg4);
        int maximum = max;
        int minimum = Math.min(min, maximum);
        maximum = Math.max(maximum, actual);
        minimum = Math.min(minimum, actual);
        boolean bl = isChange = actual != this.actualValue || minimum != this.minimalValue || maximum != this.maximalValue;
        if (isChange) {
            this.actualValue = actual;
            this.minimalValue = minimum;
            this.maximalValue = maximum;
            this.valueChanged();
        }
    }

    @Override
    public void setValue(int arg0) {
        this.setRangeProperties(arg0, 0, this.minimalValue, this.maximalValue, this.isAdjusting);
    }

    public boolean canEstimateTime() {
        return this.canEstimateTime;
    }

    public void setCanEstimateTime(boolean canEstimateTime) {
        this.canEstimateTime = canEstimateTime;
    }

    public boolean canGiveTextualProgress() {
        return this.canGiveTextualProgress;
    }

    public void setCanGiveTextualProgress(boolean canGiveTextualProgress) {
        this.canGiveTextualProgress = canGiveTextualProgress;
    }

    public boolean canShowTime() {
        return this.canShowTime;
    }

    public void setCanShowTime(boolean canShowTime) {
        this.canShowTime = canShowTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
        this.valueChanged();
    }

    public void setCanAutoDipose(boolean newCanAutoDispose) {
        this.canAutoDispose = newCanAutoDispose;
    }

    public boolean canAutoDispose() {
        return this.canAutoDispose;
    }
}

