/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.application.interaction.model.InvocationSelectionMode;
import com.schneide.base.application.interaction.model.implementation.GenericProcessContextHandler;
import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.process.generic.ProcessActivationMethod;
import com.schneide.base.application.process.generic.ProcessReference;
import com.schneide.base.application.process.generic.ProcessStarter;
import com.schneide.base.application.process.generic.SchneideAction;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import com.schneide.base.threading.SchneideThread;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;

public class SwingSchneideAction<S extends SchneideSession<U>, U extends SchneideUser>
extends AbstractAction
implements SchneideAction<S, U> {
    private static final long serialVersionUID = -7595766972643356297L;
    private final S session;
    private final AbstractSchneideProcess<S> targetProcess;
    private final String threadName;
    private final ActivationContextProvider contextProvider;
    private final ProcessActivationMethod entranceSpecification;
    private final GenericProcessContextHandler temporaryContextHandler;
    private ProcessStarter processStarter;
    private Exception lastHappenedException;

    public SwingSchneideAction(S session, AbstractSchneideProcess<S> targetProcess, String title, String threadDisplayName, ActivationContextProvider contextProvider, ProcessActivationMethod entranceSpecification, Object ... temporaryParameters) {
        super(title);
        this.session = session;
        this.contextProvider = contextProvider;
        this.targetProcess = targetProcess;
        this.threadName = threadDisplayName;
        this.entranceSpecification = entranceSpecification;
        this.temporaryContextHandler = new GenericProcessContextHandler(temporaryParameters);
        this.processStarter = new ProcessStarter();
    }

    public ActivationContextProvider getContextProvider() {
        return this.contextProvider;
    }

    protected GenericProcessContextHandler getTemporaryContextHandler() {
        return this.temporaryContextHandler;
    }

    protected final Logger getLogger() {
        return Base.getLogger((Object)this);
    }

    @Override
    public String getWorkerThreadName() {
        return this.threadName;
    }

    @Override
    public AbstractSchneideProcess<S> getProcess() {
        return this.targetProcess;
    }

    public String getProcessActivationMethodName() {
        return this.entranceSpecification.getMethodName();
    }

    public void setProcessStarter(ProcessStarter processStarter) {
        this.processStarter = processStarter;
    }

    public Exception getLastHappenedException() {
        return this.lastHappenedException;
    }

    @Override
    public void run() {
        this.performBeforeProcessing();
        this.getLogger().info((Object)("Process " + this.getProcess().getName() + " starting."));
        this.startProcess();
        this.getLogger().info((Object)("Process " + this.getProcess().getName() + " has ended."));
        this.performAfterProcessing();
    }

    protected void startProcess() {
        try {
            this.processStarter.startProcess(this.reference());
        }
        catch (RuntimeException e) {
            this.lastHappenedException = e;
            throw e;
        }
    }

    public ProcessReference reference() {
        return new SwingProcessReference();
    }

    @Override
    public String getName() {
        return super.getValue("Name").toString();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean isSelected;
        InvocationSelectionMode startType = InvocationSelectionMode.TOGGLE_ENABLED;
        if (event.getSource() instanceof JCheckBoxMenuItem && !(isSelected = ((JCheckBoxMenuItem)event.getSource()).isSelected())) {
            startType = InvocationSelectionMode.TOGGLE_DISABLED;
        }
        this.perform(startType);
    }

    @Override
    public void performBeforeProcessing() {
    }

    @Override
    public void performAfterProcessing() {
    }

    @Override
    public Thread perform(Object ... temporaryParameters) {
        for (Object each : temporaryParameters) {
            this.temporaryContextHandler.registerProcessContextObject(each);
        }
        return this.perform(InvocationSelectionMode.TOGGLE_ENABLED);
    }

    @Override
    public Thread perform(InvocationSelectionMode startType) {
        this.temporaryContextHandler.registerProcessContextObject((Object)startType);
        this.getLogger().info((Object)("Die Aktion " + this.getName() + " wird ausgef\u00fchrt mit Startzustand " + String.valueOf((Object)startType)));
        SchneideThread worker = SchneideThread.createWorkerThread((String)this.getWorkerThreadName(), (Runnable)this);
        worker.startThread();
        return worker;
    }

    @Override
    public S getSession() {
        return this.session;
    }

    protected class SwingProcessReference
    implements ProcessReference {
        @Override
        public ActivationContextProvider[] getContextProviders() {
            return new ActivationContextProvider[]{SwingSchneideAction.this.getTemporaryContextHandler(), SwingSchneideAction.this.getContextProvider()};
        }

        @Override
        public Process getProcessInstance() {
            return SwingSchneideAction.this.getProcess();
        }

        @Override
        public String getActivationMethodName() {
            return SwingSchneideAction.this.getProcessActivationMethodName();
        }
    }
}

