/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import com.schneide.base.util.EqualnessUtil;
import java.util.ArrayList;
import java.util.List;

public final class ProcessRegistry {
    private static List<Process> processesList = new ArrayList<Process>();

    private ProcessRegistry() {
    }

    private static Logger getLogger() {
        return Base.getLogger(ProcessRegistry.class);
    }

    public static synchronized void addRunningProcess(Process process) {
        ProcessRegistry.getLogger().debug((Object)("Process registered as running: " + process.getName()));
        processesList.add(process);
    }

    public static synchronized boolean removeRunningProcess(Process process) {
        ProcessRegistry.getLogger().debug((Object)("Process deregistered from running: " + process.getName()));
        return processesList.remove(process);
    }

    public static synchronized boolean isProcessesRunningFor(SchneideSession<SchneideUser> session) {
        for (Process process : processesList) {
            if (!EqualnessUtil.isEqualOrBothNull(session, process.getProcessDescriptor().getSessionContext())) continue;
            return true;
        }
        return false;
    }

    public static synchronized Process[] getProcessesRunningFor(SchneideSession<SchneideUser> session) {
        return ProcessRegistry.getProcessesForCondition(entry -> EqualnessUtil.isEqualOrBothNull((Object)session, entry.getProcessDescriptor().getSessionContext()));
    }

    public static synchronized Process[] getAllProcessesRunning() {
        return ProcessRegistry.getProcessesForCondition(entry -> true);
    }

    private static synchronized Process[] getProcessesForCondition(IProcessCondition condition) {
        ArrayList<Process> result = new ArrayList<Process>();
        for (Process entry : processesList) {
            if (!condition.isConditionMet(entry)) continue;
            result.add(entry);
        }
        return result.toArray(new Process[result.size()]);
    }

    private static interface IProcessCondition {
        public boolean isConditionMet(Process var1);
    }
}

