/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.process.generic.Process;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import com.schneide.base.util.Parameter;
import java.lang.reflect.Constructor;

public final class ProcessLoader {
    private ProcessLoader() {
    }

    public static Constructor<Process> retrieveConstructorFor(String targetName, String[] processPackageNames, Class<? extends Process> processBaseClass, Class<?> ... constructorArgumentTypes) throws ClassNotFoundException {
        Parameter.isPresent((Object)targetName);
        if (".".equals(targetName)) {
            throw new ClassNotFoundException("The process " + targetName + " was not found in the application environment.");
        }
        for (String element : processPackageNames) {
            Constructor<Process> constructor = ProcessLoader.peekForConstructor(element, targetName, processBaseClass, constructorArgumentTypes);
            if (null == constructor) continue;
            return constructor;
        }
        throw new ClassNotFoundException("The process " + targetName + " was not found in the application environment.");
    }

    protected static Constructor<Process> peekForConstructor(String element, String targetName, Class<? extends Process> processBaseClass, Class<?> ... constructorArgumentTypes) {
        try {
            return ProcessLoader.linkTargetProcess(ProcessLoader.getFullProcessName(element, targetName), processBaseClass, constructorArgumentTypes);
        }
        catch (ClassNotFoundException e) {
            ProcessLoader.swallow(e);
            return null;
        }
    }

    protected static String getFullProcessName(String element, String targetName) {
        StringBuilder fullProcessName = new StringBuilder(targetName);
        if (targetName.indexOf(element) < 0) {
            fullProcessName.insert(0, element + ".");
        }
        return fullProcessName.toString();
    }

    private static void swallow(ClassNotFoundException e) {
        e.getMessage();
    }

    private static Class<?> loadClassForName(String name) throws ClassNotFoundException {
        return ProcessLoader.getClassLoader().loadClass(name);
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static Constructor<Process> linkTargetProcess(String processClassName, Class<? extends Process> processBaseClass, Class<?>[] argumentTypes) throws ClassNotFoundException {
        Class<?> theClass = ProcessLoader.loadClassForName(processClassName);
        if (processBaseClass.isAssignableFrom(theClass)) {
            try {
                Constructor<Process> constructor = ProcessLoader.findMatchingConstructor(theClass.getConstructors(), argumentTypes);
                return constructor;
            }
            catch (NoSuchMethodException e) {
                String message = "Die Prozessklasse '" + processClassName + "' weist keinen geeigneten Konstruktor auf.";
                ProcessLoader.getLogger().error((Object)message, (Throwable)e);
                throw new ClassNotFoundException(message);
            }
        }
        throw new ClassNotFoundException("Der Prozessname verweist auf ein Objekt falschen Typs.");
    }

    private static Logger getLogger() {
        return Base.getLogger(ProcessLoader.class);
    }

    private static Constructor<Process> findMatchingConstructor(Constructor<?>[] constructors, Class<?>[] argumentTypes) throws NoSuchMethodException {
        for (Constructor<Process> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != argumentTypes.length || !ProcessLoader.matchTypes(parameterTypes, argumentTypes)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("Kein passender Konstruktor gefunden.");
    }

    private static boolean matchTypes(Class<?>[] parameterTypes, Class<?>[] argumentTypes) {
        for (int j = 0; j < parameterTypes.length; ++j) {
            if (argumentTypes[j].isAssignableFrom(parameterTypes[j])) continue;
            return false;
        }
        return true;
    }
}

