/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.util.Parameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvoker<TYPE>
extends LoggedObject {
    private final String invocationDenotation;

    public MethodInvoker(String invocationDenotation) {
        this.invocationDenotation = invocationDenotation;
    }

    protected void performBeforeInvocation(TYPE targetInstance) {
        Parameter.isPresent(targetInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(TYPE targetInstance, Method targetMethod, ActivationContextProvider ... contextProviders) {
        Object[] parameters = this.getCallParameters(targetMethod, contextProviders);
        this.performBeforeInvocation(targetInstance);
        try {
            Object object = targetMethod.invoke(targetInstance, parameters);
            return object;
        }
        catch (IllegalArgumentException e) {
            this.handleException(targetInstance, e);
        }
        catch (IllegalAccessException e) {
            this.handleException(targetInstance, e);
        }
        catch (InvocationTargetException e) {
            this.handleException(targetInstance, e);
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
        }
        finally {
            this.performAfterInvocation(targetInstance);
        }
        return null;
    }

    protected void performAfterInvocation(TYPE targetInstance) {
        Parameter.isPresent(targetInstance);
    }

    protected void handleException(TYPE targetInstance, IllegalArgumentException e) {
        this.getLogger().error((Object)(this.getInvocationDenotation() + " got wrong parameters on call for " + String.valueOf(targetInstance)), (Throwable)e);
    }

    protected void handleException(TYPE targetInstance, IllegalAccessException e) {
        this.getLogger().error((Object)("The activation method is not accessible for " + this.getInvocationDenotation() + " and " + String.valueOf(targetInstance)), (Throwable)e);
    }

    protected void handleException(TYPE targetInstance, InvocationTargetException e) {
        this.getLogger().error((Object)("The activation method produced errors for " + this.getInvocationDenotation() + " and " + String.valueOf(targetInstance)), (Throwable)e);
    }

    protected String getInvocationDenotation() {
        return this.invocationDenotation;
    }

    protected Object[] getCallParameters(Method method, ActivationContextProvider ... contextProviders) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        block0: for (int i = 0; i < result.length; ++i) {
            for (ActivationContextProvider provider : contextProviders) {
                if (!provider.hasContextObjectFor(parameterTypes[i])) continue;
                result[i] = provider.getContextObjectFor(parameterTypes[i]);
                continue block0;
            }
        }
        return result;
    }
}

