/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.generic;

import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.system.Base;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.text.transformation.Embrace;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ActivationMethodFinder
extends LoggedObject {
    private final String requiredMethodName;

    public ActivationMethodFinder(String requiredMethodName) {
        this.requiredMethodName = requiredMethodName;
    }

    public Method getCalledActivationMethod(String processName, Class<? extends Object> targetClass, ActivationContextProvider ... contextProviders) throws NoSuchMethodException {
        HashSet potentialParameterTypes = new HashSet();
        List<ActivationContextProvider> providers = Arrays.asList(contextProviders);
        for (Method each : this.getActivationMethods(targetClass, this.requiredMethodName)) {
            Class<?>[] requiredTypes = each.getParameterTypes();
            Collections.addAll(potentialParameterTypes, requiredTypes);
            if (!this.isParametersProvided(providers, Arrays.asList(requiredTypes))) continue;
            return each;
        }
        return this.createNoSuchMethodException(processName, this.missingParametersFor(providers, potentialParameterTypes));
    }

    protected Method createNoSuchMethodException(String processName, Iterable<Class<?>> mostLikelyMissing) throws NoSuchMethodException {
        StringBuilder exceptionMessage = new StringBuilder();
        exceptionMessage.append("Could not find a parametrisable activation method named ");
        exceptionMessage.append(Embrace.withSingleQuotes((Object)this.requiredMethodName));
        exceptionMessage.append(" for the process ");
        exceptionMessage.append(Embrace.withSingleQuotes((Object)processName));
        DirectChunkBuffer typeList = new DirectChunkBuffer(',');
        for (Class<?> each : mostLikelyMissing) {
            typeList.add((CharSequence)each.getSimpleName());
        }
        exceptionMessage.append("; most likely missing: " + Embrace.withParentheses((Object)typeList.toString()));
        throw new NoSuchMethodException(exceptionMessage.toString());
    }

    protected boolean isParametersProvided(Iterable<ActivationContextProvider> contextProviders, Iterable<Class<?>> parameterTypes) {
        if (IterableUtil.isEmpty(parameterTypes)) {
            return true;
        }
        for (Class<?> each : parameterTypes) {
            if (this.isProvidedBy(contextProviders, each)) continue;
            return false;
        }
        return true;
    }

    protected boolean isProvidedBy(Iterable<ActivationContextProvider> contextProviders, Class<?> parameterType) {
        for (ActivationContextProvider currentProvider : contextProviders) {
            if (!currentProvider.hasContextObjectFor(parameterType)) continue;
            return true;
        }
        return false;
    }

    protected Iterable<Class<?>> missingParametersFor(Iterable<ActivationContextProvider> contextProviders, Iterable<Class<?>> parameterTypes) {
        HashSet result = new HashSet();
        for (Class<?> each : parameterTypes) {
            if (this.isProvidedBy(contextProviders, each)) continue;
            result.add(each);
        }
        return result;
    }

    protected Method[] getActivationMethods(Class<? extends Object> processClass, String activationMethodName) {
        Method[] methods = processClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method element : methods) {
            if (!activationMethodName.equals(element.getName())) continue;
            if (Modifier.isPublic(element.getModifiers())) {
                result.add(element);
                continue;
            }
            Base.getLogger(ActivationMethodFinder.class).warn((Object)("Found a non-accessible activation method in process class " + processClass.getName()));
        }
        result.sort(new ParameterCountComparator(this));
        return result.toArray(new Method[result.size()]);
    }

    private class ParameterCountComparator
    implements Comparator<Method> {
        public ParameterCountComparator(ActivationMethodFinder activationMethodFinder) {
        }

        @Override
        public int compare(Method m1, Method m2) {
            return m2.getParameterCount() - m1.getParameterCount();
        }
    }
}

