/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron.management;

import com.schneide.base.application.process.cron.management.CronTriggerManager;
import com.schneide.base.logging.LoggedObject;
import java.util.Date;
import org.joda.time.DateTime;
import org.quartz.Trigger;

public class QuartzBasedTriggerFireTimes
extends LoggedObject
implements CronTriggerManager.TriggerFireTimes {
    private static final DateTime EARLIEST_TIMES = new DateTime(Long.MIN_VALUE);
    private static final DateTime DISTANT_FUTURE = new DateTime(Long.MAX_VALUE);
    private final Trigger trigger;
    private final boolean isEnabled;

    public QuartzBasedTriggerFireTimes(Trigger trigger, boolean isEnabled) {
        this.trigger = trigger;
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public DateTime nextFiring() {
        return this.firingTimeFor(this.trigger.getNextFireTime(), DISTANT_FUTURE);
    }

    @Override
    public DateTime lastFiring() {
        return this.firingTimeFor(this.trigger.getPreviousFireTime(), EARLIEST_TIMES);
    }

    protected DateTime firingTimeFor(Date quartzInfo, DateTime fallback) {
        if (null == quartzInfo) {
            return fallback;
        }
        return new DateTime((Object)quartzInfo);
    }
}

