/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron;

import com.schneide.base.application.process.cron.SchneideProcessJob;
import com.schneide.base.application.process.generic.Process;
import com.schneide.base.application.process.generic.ProcessRegistry;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.threading.SchneideThread;
import org.joda.time.Duration;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SchneideQuartzJob
extends LoggedObject
implements Job {
    private final SchneideProcessJob job;
    private Thread executingThread;

    public SchneideQuartzJob(SchneideProcessJob job) {
        this.job = job;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.executingThread = Thread.currentThread();
        if (this.getJob().isExecutionExclusive()) {
            this.waitForNoProcessRunning();
        }
        this.getLogger().debug((Object)("Running process '" + this.getJob().getProcessName() + "' triggered by '" + context.getTrigger().getFullName() + "'"));
        this.getJob().getAction().run();
    }

    private SchneideProcessJob getJob() {
        return this.job;
    }

    private void waitForNoProcessRunning() {
        while (this.isProcessRunning()) {
            this.getLogger().debug((Object)"There are still processes running. Performing delay and checking again...");
            SchneideThread.performDelay((long)60000L);
        }
    }

    private boolean isProcessRunning() {
        Process[] processes = ProcessRegistry.getAllProcessesRunning();
        if (processes.length > 0) {
            this.getLogger().debug((Object)("Process registry reports " + processes.length + " processes running."));
            for (Process object : processes) {
                this.getLogger().debug((Object)("  " + String.valueOf((Object)object.getProcessDescriptor().getType())));
            }
        }
        return processes.length > 0;
    }

    public Duration getMaximumExpectedExecutionTime() {
        return this.getJob().getMaximumExpectedExecutionTime();
    }

    public Thread getExecutingThread() {
        return this.executingThread;
    }
}

