/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.cron;

import com.schneide.base.application.process.cron.SchneideProcessJob;
import com.schneide.base.application.process.cron.SchneideQuartzJob;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class SchneideProcessJobFactory
implements JobFactory {
    private final Map<String, SchneideProcessJob> jobMap = new HashMap<String, SchneideProcessJob>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJob(SchneideProcessJob job) {
        if (job != null) {
            Map<String, SchneideProcessJob> map = this.jobMap;
            synchronized (map) {
                this.jobMap.put(job.getProcessName(), job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterJob(String processName) {
        Map<String, SchneideProcessJob> map = this.jobMap;
        synchronized (map) {
            this.jobMap.remove(processName);
        }
    }

    public Job newJob(TriggerFiredBundle bundle) throws SchedulerException {
        SchneideProcessJob job = this.getJob(bundle.getJobDetail().getName());
        return new SchneideQuartzJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchneideProcessJob getJob(String processName) throws SchedulerException {
        Map<String, SchneideProcessJob> map = this.jobMap;
        synchronized (map) {
            SchneideProcessJob job = this.jobMap.get(processName);
            if (job == null) {
                throw new SchedulerException("Could not find job for " + processName);
            }
            return job;
        }
    }
}

