/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.context.collect;

import com.schneide.base.logging.LoggedObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class GetterMethodBasedContextObjectProvider {
    private static final String[] RESTRICTED_METHOD_NAMES = new String[]{"getClass"};

    private GetterMethodBasedContextObjectProvider() {
    }

    public static Object[] retrieveObjectsByGetterMethodsFrom(Object instance) {
        Method[] methods;
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Method method : methods = instance.getClass().getMethods()) {
            if (!GetterMethodBasedContextObjectProvider.isApplicableGetterMethod(method)) continue;
            try {
                Object newObject = method.invoke(instance, new Object[0]);
                if (null == newObject) {
                    LoggedObject.getStaticLogger().warn((Object)("The return value of " + method.getName() + " was null."));
                }
                resultList.add(newObject);
            }
            catch (IllegalArgumentException e) {
                LoggedObject.getStaticLogger().error((Object)"Illegal argument when invoking method reflectively.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LoggedObject.getStaticLogger().error((Object)"Illegal access when invoking method reflectively.", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LoggedObject.getStaticLogger().error((Object)"Something went wrong when invoking method reflectively.", (Throwable)e);
            }
        }
        return resultList.toArray(new Object[resultList.size()]);
    }

    private static boolean isApplicableGetterMethod(Method method) {
        return GetterMethodBasedContextObjectProvider.isGetterMethod(method) && GetterMethodBasedContextObjectProvider.isAccessible(method) && GetterMethodBasedContextObjectProvider.hasNoArguments(method) && !GetterMethodBasedContextObjectProvider.isRestrictedMethod(method);
    }

    private static boolean hasNoArguments(Method method) {
        return method.getParameterTypes().length == 0;
    }

    private static boolean isAccessible(Method method) {
        return (method.getModifiers() | 1) > 0;
    }

    private static boolean isGetterMethod(Method method) {
        return method.getName().startsWith("get");
    }

    private static boolean isRestrictedMethod(Method method) {
        for (String restrictedName : RESTRICTED_METHOD_NAMES) {
            if (!method.getName().equals(restrictedName)) continue;
            return true;
        }
        return false;
    }
}

