/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process.autoexecution;

import com.schneide.base.application.ApplicationEngine;
import com.schneide.base.application.process.autoexecution.GenericProcessExecutionSpecification;
import com.schneide.base.application.process.autoexecution.ProcessExecutionSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.applicationLevel.BooleanProperty;
import com.schneide.base.properties.applicationLevel.PropertyReference;
import com.schneide.base.properties.applicationLevel.PropertyReferenceType;
import com.schneide.base.system.Base;
import java.util.ArrayList;

public class AutoProcessExecutor<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_SYNCHRONIZED = "synchronized";
    private static final String KEY_PROCESS = "process";
    private static final String SECTION_AUTOPROCESS = "autoprocess";
    private final ProcessExecutionSpecification[] specifications;

    public AutoProcessExecutor(VirtualFile configurationFile) {
        this(new Configuration(new VirtualFile[]{configurationFile}));
    }

    public AutoProcessExecutor(Configuration configuration) {
        this(AutoProcessExecutor.retrieveSpecifications(configuration));
    }

    private static ProcessExecutionSpecification[] retrieveSpecifications(Configuration configuration) {
        ConfigurationSection[] sections = configuration.getSections(SECTION_AUTOPROCESS);
        Base.getDefaultLogger().debug((Object)(sections.length + " Prozesse f\u00fcr Autostart geladen."));
        ArrayList<GenericProcessExecutionSpecification> specificationList = new ArrayList<GenericProcessExecutionSpecification>();
        for (ConfigurationSection element : sections) {
            String processName = element.getProperty(KEY_PROCESS).getValue();
            String denotation = element.getPartIdentifier();
            boolean isSynchronized = AutoProcessExecutor.extractBooleanFrom(element, KEY_SYNCHRONIZED, false);
            boolean isEnabled = AutoProcessExecutor.extractBooleanFrom(element, KEY_ENABLED, true);
            specificationList.add(new GenericProcessExecutionSpecification(processName, denotation, isEnabled, isSynchronized));
        }
        return specificationList.toArray(new ProcessExecutionSpecification[specificationList.size()]);
    }

    private static boolean extractBooleanFrom(ConfigurationSection section, String key, boolean standardValue) {
        if (section.hasProperty(key)) {
            BooleanProperty property = BooleanProperty.buildConfigured((ConfigurationPart)section, (PropertyReferenceType)PropertyReference.forKey((String)key));
            return property.getValue();
        }
        return standardValue;
    }

    public AutoProcessExecutor(ProcessExecutionSpecification[] specifications) {
        this.specifications = specifications;
    }

    public void execute(ApplicationEngine<S, U> engine, S session) {
        for (ProcessExecutionSpecification element : this.specifications) {
            if (!element.isEnabled()) continue;
            this.executeProcess(element, engine, session);
        }
    }

    private void executeProcess(ProcessExecutionSpecification specification, ApplicationEngine<S, U> engine, S session) {
        Thread currentProcess = engine.runProcess(specification.getProcessName(), session);
        if (specification.isSynchronized()) {
            try {
                currentProcess.join();
            }
            catch (InterruptedException e) {
                Base.getLogger((Object)((Object)this)).warn((Object)"Unterbrochen.", (Throwable)e);
            }
        }
    }
}

