/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process;

import com.schneide.base.application.process.AbstractZippedExportProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.io.file.Directory;
import com.schneide.base.text.buffer.DirectChunkBuffer;
import com.schneide.base.timing.Clock;
import java.io.File;

public class ExportLogfilesProcess
extends AbstractZippedExportProcess {
    public ExportLogfilesProcess(SchneideSession<?> session) {
        super(session);
    }

    @Override
    protected String getContentDescription() {
        return new I18NKey("ExportLogfilesProcess.content.description").resolvedText();
    }

    @Override
    protected String getProgressDenotation() {
        return new I18NKey("ExportLogfilesProcess.progress.denotation").resolvedText();
    }

    @Override
    public File getTargetFilePreselection() {
        return new File(this.getTimestamp() + "_logs.zip");
    }

    protected String getTimestamp() {
        return Clock.getTimeIndexString();
    }

    @Override
    protected String getZipComment() {
        DirectChunkBuffer buffer = new DirectChunkBuffer((CharSequence)" ");
        buffer.add((CharSequence)this.getProgressDenotation());
        buffer.add((CharSequence)new I18NKey("timestamp.at").resolvedText());
        buffer.add((CharSequence)Clock.getDateTimeString());
        return buffer.toString();
    }

    @Override
    protected Iterable<File> getSourceFiles() {
        return new SingleElementIterable((Object)Directory.forPath((String)"logs"));
    }
}

