/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.process;

import com.schneide.base.application.dialog.module.ModeChangeDialog;
import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleCreator;
import com.schneide.base.application.module.ModuleException;
import com.schneide.base.application.periphery.ModuleRepository;
import com.schneide.base.application.process.generic.AbstractSchneideProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;

public class ChangeModuleModesProcess
extends AbstractSchneideProcess<SchneideSession<? extends SchneideUser>> {
    public ChangeModuleModesProcess(SchneideSession<SchneideUser> session) {
        super(session);
    }

    public void activateFor(ModuleCreator creator, ModuleRepository modules) {
        ModeChangeDialog dialog = new ModeChangeDialog((SchneideSession<? extends SchneideUser>)this.session(), modules);
        dialog.showDialog();
        if (dialog.wasClosedByCancel()) {
            return;
        }
        Iterable<ModeChangeDialog.ModuleModeChange> changes = dialog.requiredChanges();
        for (ModeChangeDialog.ModuleModeChange each : changes) {
            String moduleName = each.module().specification().getIdentifier();
            String newModeName = each.newMode().getDenotation();
            this.getLogger().info((Object)("The module " + moduleName + " is required to change to mode " + newModeName));
            this.getLogger().info((Object)("It currently runs in mode " + each.module().specification().getMode().getDenotation()));
            ApplicationModule<?> module = each.module();
            this.getLogger().info((Object)"Stopping current mode");
            try {
                module.stopModule();
            }
            catch (ModuleException e) {
                this.getLogger().error((Object)"The currently active module mode couldn't be stopped without problems.", (Throwable)e);
            }
            modules.remove(module);
            this.getLogger().info((Object)"Starting new mode");
            creator.createAndStartFor(module, each.newMode());
        }
    }
}

