/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module.state;

import com.schneide.base.application.module.ModuleTypeSpecification;
import com.schneide.base.application.module.news.ModuleStateChanged;
import com.schneide.base.application.module.state.ModuleState;
import com.schneide.base.application.module.state.ModuleStateProvider;
import com.schneide.base.eventbus.EventBus;
import com.schneide.base.eventbus.util.Subscriber;
import com.schneide.base.logging.LoggedObject;
import java.util.HashMap;
import java.util.Map;

public class ModuleStateCache
extends LoggedObject
implements ModuleStateProvider {
    private final Map<String, ModuleState> latestStates = new HashMap<String, ModuleState>();
    private final Subscriber<ModuleStateChanged> allChanges = new Subscriber(ModuleStateChanged.class, news -> {
        Map<String, ModuleState> map = this.latestStates;
        synchronized (map) {
            this.latestStates.put(news.forModule().getIdentifier(), news.toState());
        }
    });

    public void subscribeTo(EventBus applicationBus) {
        Subscriber.attach(this.allChanges, (EventBus)applicationBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleState latestStateFor(ModuleTypeSpecification moduleType) {
        Map<String, ModuleState> map = this.latestStates;
        synchronized (map) {
            String lookupKey = moduleType.getIdentifier();
            if (!this.latestStates.containsKey(lookupKey)) {
                return ModuleState.unknown;
            }
            return this.latestStates.get(lookupKey);
        }
    }
}

