/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.module;

import com.schneide.base.application.module.ModuleTypeSpecification;
import com.schneide.base.application.module.configuration.ModuleConfiguration;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.ConfigurationPart;
import com.schneide.base.properties.ConfigurationSection;
import com.schneide.base.properties.userLevel.Configured;
import com.schneide.base.properties.userLevel.SuffixProvider;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class ModulesConfiguration
extends LoggedObject {
    private static final String SECTION_MODULE = "modul";
    private final Configuration configuration;
    private final SuffixProvider suffix;

    public ModulesConfiguration(VirtualFile configurationFile, SuffixProvider suffix) {
        this.suffix = suffix;
        this.configuration = new Configuration(new VirtualFile[]{configurationFile});
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Iterable<ModuleConfiguration> getModuleConfigurations() {
        ConfigurationSection[] sections;
        ArrayList<ModuleConfiguration> result = new ArrayList<ModuleConfiguration>();
        for (ConfigurationSection element : sections = this.getConfiguration().getSections(SECTION_MODULE)) {
            result.add(new SectionBackedModuleConfiguration(element, this.suffix));
        }
        return result;
    }

    public Iterable<ModuleConfiguration> getModuleConfigurationsFor(ModuleTypeSpecification module) throws NoSuchElementException {
        return this.getModuleConfigurationsFor(module.getIdentifier());
    }

    public Iterable<ModuleConfiguration> getModuleConfigurationsFor(String moduleIdentifier) throws NoSuchElementException {
        ArrayList<ModuleConfiguration> matchingConfigs = new ArrayList<ModuleConfiguration>();
        for (ModuleConfiguration element : this.getModuleConfigurations()) {
            if (!moduleIdentifier.equals(element.getModuleTypeIdentifier())) continue;
            matchingConfigs.add(element);
        }
        if (matchingConfigs.isEmpty()) {
            this.getLogger().warn((Object)("Konnte keine Konfiguration f\u00fcr das Modul " + moduleIdentifier + " finden."));
        }
        return matchingConfigs;
    }

    private static class SectionBackedModuleConfiguration
    implements ModuleConfiguration {
        private static final String SELECTION_ENABLED = "manuelle.auswahl.des.betriebsmodus[ja/nein]";
        private static final String MODUS_SELECTED = "betriebsmodus.ausgew\u00e4hlt";
        private static final String INSTANCE_DENOTATION = "bezeichnung";
        private static final String TYPE_IDENTIFIER = "typ";
        private static final String CONFIGURATION = "konfiguration";
        private final ConfigurationSection section;
        private final SuffixProvider suffix;

        public SectionBackedModuleConfiguration(ConfigurationSection section, SuffixProvider suffix) {
            this.section = section;
            this.suffix = suffix;
        }

        @Override
        public String getModuleTypeIdentifier() {
            return this.propertyFor(TYPE_IDENTIFIER);
        }

        @Override
        public String getSelectedModeIdentifier() {
            return this.propertyFor(MODUS_SELECTED);
        }

        @Override
        public String getModuleInstanceIdentifier() {
            return this.section.getIdentifier();
        }

        @Override
        public String getModuleInstanceDenotation() {
            return this.propertyFor(INSTANCE_DENOTATION);
        }

        @Override
        public String getModuleSpecificConfiguration() {
            return this.propertyFor(CONFIGURATION);
        }

        @Override
        public boolean isSelectionEnabled() {
            return Configured.entry((String)SELECTION_ENABLED).suffixedWith(this.suffix).asBoolean().withFallback(false).in((ConfigurationPart)this.section);
        }

        private String propertyFor(String key) {
            return Configured.entry((String)key).suffixedWith(this.suffix).asString().in((ConfigurationPart)this.section);
        }
    }
}

