/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.login;

import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.dialog.LoginCredentialProvider;
import com.schneide.base.application.dialog.LoginFrame;
import com.schneide.base.application.handler.ShutdownHandler;
import com.schneide.base.application.login.LoginHandler;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.crypto.Password;
import com.schneide.base.application.usermanagement.model.LoginException;
import com.schneide.base.application.usermanagement.model.RightIdentifier;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.logging.LoggedObject;
import java.util.Optional;
import java.util.function.Supplier;

public class SessionAuthentificationLoginHandler<U extends SchneideUser>
extends LoggedObject
implements LoginHandler<U> {
    protected static final LoginCredentialProvider CANCELLED_LOGIN = new LoginCredentialProvider(){

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public Password getPassword() {
            return null;
        }
    };
    private final SchneideApplication application;
    private final Optional<RightIdentifier> requirement;
    private final Supplier<Boolean> initiallyShown;

    public SessionAuthentificationLoginHandler(SchneideApplication application, Supplier<Boolean> initiallyShown, Optional<RightIdentifier> requirement) {
        this.application = application;
        this.initiallyShown = initiallyShown;
        this.requirement = requirement;
    }

    @Override
    public U performLogin(UserManager<U> userManager, ShutdownHandler<? extends SchneideSession<U>> shutdownHandler) {
        Object result = null;
        String message = "";
        while (result == null) {
            LoginCredentialProvider credentials = this.fetchLoginCredentials(message, shutdownHandler);
            if (CANCELLED_LOGIN == credentials) {
                message = "";
                continue;
            }
            try {
                boolean permitted;
                result = this.createFromCredentials(userManager, credentials);
                if (!this.requirement.isPresent() || (permitted = userManager.hasPermission(result, this.requirement.get()))) continue;
                result = null;
                message = "Sie haben keine Zugangsberechtigung.";
            }
            catch (LoginException e) {
                this.getLogger().warn((Object)"Login failure.", (Throwable)e);
                message = new DirectText("Benutzername nicht gefunden oder Passwort falsch.").resolvedText();
            }
        }
        return result;
    }

    protected LoginCredentialProvider fetchLoginCredentials(String currentMessage, ShutdownHandler<? extends SchneideSession<U>> shutdownHandler) {
        LoginFrame loginFrame = new LoginFrame(this.application, currentMessage);
        if (!this.initiallyShown.get().booleanValue()) {
            loginFrame.setExtendedState(1);
        }
        loginFrame.setVisible(true);
        loginFrame.waitForClose();
        if (loginFrame.isCancelled()) {
            if (loginFrame.isShutdown()) {
                try {
                    shutdownHandler.shutdownApplication(null);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().error((Object)"Das Herunterfahren aus dem Login-Dialog hat nicht funktioniert.", (Throwable)e);
                }
            }
            return CANCELLED_LOGIN;
        }
        return loginFrame;
    }

    protected U createFromCredentials(UserManager<U> userManager, LoginCredentialProvider credentials) throws LoginException {
        return userManager.handleLogin(credentials.getUserName(), credentials.getPassword());
    }
}

