/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.loaders;

import com.schneide.base.application.interaction.configuration.MenuConfiguration;
import com.schneide.base.application.interaction.handler.CommentLineHandler;
import com.schneide.base.application.interaction.i18n.MenuI18N;
import com.schneide.base.application.interaction.i18n.MenuItemI18N;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.interaction.model.MenuItemType;
import com.schneide.base.application.interaction.model.implementation.GenericMenuBarSpecification;
import com.schneide.base.application.interaction.model.implementation.MenuSeparatorSpecification;
import com.schneide.base.application.interaction.model.implementation.SwingMenuItemSpecification;
import com.schneide.base.application.interaction.model.implementation.SwingMenuSpecification;
import com.schneide.base.application.loaders.MenuSpecificationProvider;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.io.encoding.Encoding;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.text.Text;
import com.schneide.base.text.parsing.LineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.Scanner;

public class MenuSpecificationLoader<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements MenuSpecificationProvider<S, U> {
    private static final Charset usedEncoding = Encoding.utf8();
    private final ActionManager<S, U> actionManager;
    private final MenuConfiguration configuration;
    private final CommentLineHandler commentHandler;
    private GenericMenuBarSpecification<S, U> menuSpecification = null;

    public MenuSpecificationLoader(ActionManager<S, U> actionManager, MenuConfiguration configuration) {
        this.actionManager = actionManager;
        this.configuration = configuration;
        this.commentHandler = new CommentLineHandler();
    }

    private GenericMenuBarSpecification<S, U> load() {
        SpecificationParser specificationParser = new SpecificationParser();
        ResourceParser resourceParser = new ResourceParser(this, specificationParser.getParseResult());
        this.loadMenubarSpecification(specificationParser, this.configuration.getMenuSpecificationFile(), resourceParser, this.configuration.getMenuResourcesFile(), false);
        this.menuSpecification = this.loadMenubarSpecification(specificationParser, this.configuration.getInternalMenuSpecificationFile(), resourceParser, this.configuration.getInternalMenuResourcesFile(), true);
        return this.menuSpecification;
    }

    private GenericMenuBarSpecification<S, U> loadMenubarSpecification(SpecificationParser specificationParser, File menuSpecificationFile, ResourceParser resourceParser, File menuResourceFile, boolean isInternal) {
        Object message2;
        Scanner scanner;
        try {
            scanner = new Scanner(menuSpecificationFile, usedEncoding.name());
            try {
                this.loadSpecification(specificationParser, scanner, isInternal);
            }
            finally {
                scanner.close();
            }
        }
        catch (FileNotFoundException e) {
            message2 = "Eine Menudefinitionsdatei konnte nicht gefunden werden.";
            this.getLogger().error((Object)"Eine Menudefinitionsdatei konnte nicht gefunden werden.", (Throwable)e);
        }
        scanner = new Scanner(menuResourceFile, usedEncoding.name());
        try {
            message2 = this.loadResource(resourceParser, scanner, isInternal);
            scanner.close();
            return message2;
        }
        catch (Throwable message2) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable) {
                    message2.addSuppressed(throwable);
                }
                throw message2;
            }
            catch (FileNotFoundException e) {
                message2 = "Eine Menudefinitionsdatei konnte nicht gefunden werden.";
                this.getLogger().error((Object)"Eine Menudefinitionsdatei konnte nicht gefunden werden.", (Throwable)e);
                return null;
            }
        }
    }

    private boolean isSpecificationLoaded() {
        return null != this.menuSpecification;
    }

    @Override
    public GenericMenuBarSpecification<S, U> getMenuSpecification() {
        if (!this.isSpecificationLoaded()) {
            this.menuSpecification = this.load();
        }
        return this.menuSpecification;
    }

    protected ActionManager<S, U> getActionManager() {
        return this.actionManager;
    }

    protected GenericMenuBarSpecification<S, U> loadSpecification(SpecificationParser parser, Scanner reader, boolean isInternal) {
        this.parseEachLine(reader, parser, isInternal);
        return parser.getParseResult();
    }

    protected Parser parseEachLine(Scanner reader, Parser parser, boolean isInternal) {
        int lineCounter = 0;
        while (reader.hasNextLine()) {
            String line = reader.nextLine();
            if (this.commentHandler.isComment(line, this.configuration.getMenuSpecificationFile().getAbsolutePath(), ++lineCounter)) continue;
            try {
                String trimmedLine = line.trim();
                if (!Text.hasContent((String)trimmedLine)) continue;
                parser.parseLine(trimmedLine, lineCounter, isInternal);
            }
            catch (ParseException e) {
                this.getLogger().error((Object)"Lesefehler.", (Throwable)e);
            }
        }
        return parser;
    }

    protected GenericMenuBarSpecification<S, U> loadResource(ResourceParser parser, Scanner reader, boolean isInternal) {
        this.parseEachLine(reader, parser, isInternal);
        return parser.getParseResult();
    }

    private class SpecificationParser
    extends Parser {
        private final GenericMenuBarSpecification<S, U> parseResult;
        private String currentMenuReference;

        public SpecificationParser() {
            super(MenuSpecificationLoader.this);
            this.parseResult = new GenericMenuBarSpecification();
            this.currentMenuReference = null;
        }

        protected SwingMenuItemSpecification<S, U> loadMenuItem(MenuItemType type, String argumentsLine, boolean isInternal) {
            try {
                String[] arguments = this.splitArguments(argumentsLine);
                if (arguments.length >= 3) {
                    SwingMenuItemSpecification result = new SwingMenuItemSpecification(MenuSpecificationLoader.this.getActionManager(), type, arguments[0], arguments[1], arguments[2], isInternal);
                    return result;
                }
            }
            catch (ParseException e) {
                this.getLogger().error((Object)("Parse error interpreting argument " + argumentsLine), (Throwable)e);
            }
            return null;
        }

        protected SwingMenuSpecification<S, U> loadMenu(String argumentsLine, boolean isInternal) {
            try {
                String[] arguments = this.splitArguments(argumentsLine);
                if (arguments.length >= 1) {
                    SwingMenuSpecification result = new SwingMenuSpecification(arguments[0], isInternal);
                    return result;
                }
            }
            catch (ParseException e) {
                this.getLogger().error((Object)("Parse error interpreting argument " + argumentsLine), (Throwable)e);
            }
            return null;
        }

        protected boolean hasContext(String actualMenuReference, int lineCounter) {
            if (actualMenuReference == null) {
                this.getLogger().warn((Object)("Formatfehler! Kein Menukontext verf\u00fcgbar in Zeile " + lineCounter));
                return false;
            }
            return true;
        }

        public GenericMenuBarSpecification<S, U> getParseResult() {
            return this.parseResult;
        }

        @Override
        protected void parseLine(String line, int lineCounter, boolean isInternal) throws ParseException {
            int commandEnd = line.indexOf(32);
            if (commandEnd < 0) {
                commandEnd = line.length();
            }
            String elementType = line.substring(0, commandEnd);
            String elementArguments = line.substring(commandEnd);
            if ("menu".equals(elementType)) {
                SwingMenuSpecification menu = this.loadMenu(elementArguments, isInternal);
                this.currentMenuReference = menu.getReferenceName();
                this.parseResult.addMenu(menu);
            } else if ("toggle".equals(elementType)) {
                if (this.hasContext(this.currentMenuReference, lineCounter)) {
                    this.parseResult.addMenuItem(this.currentMenuReference, this.loadMenuItem(MenuItemType.CHECKBOX, elementArguments, isInternal));
                }
            } else if ("item".equals(elementType)) {
                if (this.hasContext(this.currentMenuReference, lineCounter)) {
                    this.parseResult.addMenuItem(this.currentMenuReference, this.loadMenuItem(MenuItemType.LABEL, elementArguments, isInternal));
                }
            } else if ("separator".equals(elementType)) {
                if (this.hasContext(this.currentMenuReference, lineCounter)) {
                    this.parseResult.addMenuItem(this.currentMenuReference, new MenuSeparatorSpecification());
                }
            } else {
                this.getLogger().error((Object)("Formatfehler! Falsche Syntax (Elementtyp) in Zeile " + lineCounter));
                throw new ParseException("Formatfehler in Zeile.", lineCounter);
            }
        }
    }

    private class ResourceParser
    extends Parser {
        private final GenericMenuBarSpecification<S, U> specification;

        public ResourceParser(MenuSpecificationLoader menuSpecificationLoader, GenericMenuBarSpecification<S, U> specification) {
            super(menuSpecificationLoader);
            this.specification = specification;
        }

        protected void addMenuItemResource(String arguments) {
            try {
                String[] resources = this.splitArguments(arguments);
                if (resources.length >= 4) {
                    MenuItemI18N resource = new MenuItemI18N(resources[1], resources[2], resources[3]);
                    try {
                        SwingMenuItemSpecification menuItemSpecification = (SwingMenuItemSpecification)this.specification.getSpecification(resources[0]);
                        menuItemSpecification.setI18NResource(resource);
                    }
                    catch (NoSuchElementException e1) {
                        this.getLogger().warn((Object)"MenuItemResource was not registered.", (Throwable)e1);
                    }
                } else {
                    this.getLogger().warn((Object)"MenuItemResource format error.");
                }
            }
            catch (ParseException e) {
                this.getLogger().error((Object)("Parse error interpreting argument " + arguments), (Throwable)e);
            }
        }

        protected void addMenuResource(String arguments) {
            try {
                String[] resources = this.splitArguments(arguments);
                if (resources.length >= 3) {
                    MenuI18N resource = new MenuI18N(resources[1], resources[2]);
                    try {
                        SwingMenuSpecification currentSpecification = (SwingMenuSpecification)this.specification.getSpecification(resources[0]);
                        currentSpecification.adjustI18NResource(resource);
                    }
                    catch (NoSuchElementException e1) {
                        this.getLogger().warn((Object)"MenuSpezifikation nicht hinzugef\u00fcgt.", (Throwable)e1);
                    }
                } else {
                    this.getLogger().warn((Object)"MenuResource format error.");
                }
            }
            catch (ParseException e) {
                this.getLogger().error((Object)("Parse error interpreting argument " + arguments), (Throwable)e);
            }
        }

        public GenericMenuBarSpecification<S, U> getParseResult() {
            return this.specification;
        }

        @Override
        protected void parseLine(String line, int lineCounter, boolean isInternal) throws ParseException {
            int commandEnd = line.indexOf(32);
            if (commandEnd < 0) {
                commandEnd = line.length();
            }
            String elementType = line.substring(0, commandEnd);
            String elementArguments = line.substring(commandEnd);
            if ("menu".equals(elementType) || "toggle".equals(elementType)) {
                this.addMenuResource(elementArguments);
            } else if ("item".equals(elementType)) {
                this.addMenuItemResource(elementArguments);
            } else {
                this.getLogger().error((Object)("Formatfehler! Falsche Syntax (Elementtyp) in Zeile " + lineCounter));
                throw new ParseException("Formatfehler in Zeile.", lineCounter);
            }
        }
    }

    private abstract class Parser
    extends LoggedObject {
        protected static final String SEPARATOR = "separator";
        protected static final String ITEM = "item";
        protected static final String MENU = "menu";
        protected static final String TOGGLE = "toggle";
        protected static final String PARSE_ERROR_INTERPRETING_ARGUMENT = "Parse error interpreting argument ";

        public Parser(MenuSpecificationLoader menuSpecificationLoader) {
        }

        protected abstract void parseLine(String var1, int var2, boolean var3) throws ParseException;

        protected String[] splitArguments(String line) throws ParseException {
            return new LineParser().splitArguments(line);
        }
    }
}

