/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.i18n.MenuI18N;
import com.schneide.base.application.interaction.model.MenuItemSpecification;
import com.schneide.base.application.interaction.model.MenuSpecification;
import com.schneide.base.application.interaction.model.implementation.AbstractSpecification;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.datatypes.collections.iterable.SingleElementIterable;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;
import java.util.List;

public class SwingMenuSpecification<S extends SchneideSession<U>, U extends SchneideUser>
extends AbstractSpecification
implements MenuSpecification<S, U> {
    private final List<MenuItemSpecification<S, U>> menuItemList = new ArrayList<MenuItemSpecification<S, U>>();

    public SwingMenuSpecification(String reference, boolean isInternal) {
        super(reference, isInternal);
    }

    public void adjustI18NResource(MenuI18N resource) {
        this.internalSetI18NResource(resource);
    }

    public void addMenuItem(MenuItemSpecification<S, U> specification) {
        if (specification != null) {
            this.menuItemList.add(specification);
        }
    }

    @Override
    public Iterable<MenuItemSpecification<S, U>> getMenuItems() {
        return this.menuItemList;
    }

    public void removeMenuItem(MenuItemSpecification<S, U> specification) {
        if (specification != null) {
            this.menuItemList.remove(specification);
        }
    }

    public SwingMenuSpecification<S, U> getCopyWithoutChildren() {
        SwingMenuSpecification<S, U> result = new SwingMenuSpecification<S, U>(this.getReferenceName(), this.isInternal());
        result.internalSetI18NResource(this.getI18NResource());
        return result;
    }

    @Override
    public Iterable<Object> getValuesToCompare() {
        return new SingleElementIterable(this.menuItemList);
    }

    @Override
    public int hashCode() {
        return EqualsBuilder.hashCodeFor((EqualsBuilder.EqualComparable)this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual((EqualsBuilder.EqualComparable)this, (Object)obj);
    }
}

