/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.model.ProcessContextHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class GenericProcessContextHandler
implements ProcessContextHandler {
    private final Map<Class<?>, Object> contextObjectMap = new HashMap();

    public GenericProcessContextHandler(Object ... objects) {
        for (Object object : objects) {
            this.registerProcessContextObject(object);
        }
    }

    @Override
    public void registerProcessContextObject(Object object) {
        if (null == object) {
            return;
        }
        this.registerContextObject(object.getClass(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContextObject(Class<?> type, Object object) {
        Map<Class<?>, Object> map = this.contextObjectMap;
        synchronized (map) {
            if (this.hasContextObjectFor(type)) {
                this.contextObjectMap.remove(this.getContextObjectFor(type));
            }
            this.contextObjectMap.put(type, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContextObjectFor(Class<?> type) throws NoSuchElementException {
        Map<Class<?>, Object> map = this.contextObjectMap;
        synchronized (map) {
            if (this.contextObjectMap.containsKey(type)) {
                return this.contextObjectMap.get(type);
            }
        }
        return this.getContextObjectByInstantiationTrial(type);
    }

    @Override
    public boolean hasContextObjectFor(Class<?> type) {
        try {
            this.getContextObjectFor(type);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextObjectByInstantiationTrial(Class<?> type) throws NoSuchElementException {
        Map<Class<?>, Object> map = this.contextObjectMap;
        synchronized (map) {
            for (Object object : this.contextObjectMap.values()) {
                if (!type.isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        throw new NoSuchElementException("Kein Kontextobjekt f\u00fcr Typ " + type.getName() + " registriert.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ProcessContext " + this.hashCode());
        Map<Class<?>, Object> map = this.contextObjectMap;
        synchronized (map) {
            for (Class<?> type : this.contextObjectMap.keySet()) {
                result.append("- ");
                result.append(type.getCanonicalName());
                result.append(": ");
                result.append(String.valueOf(this.contextObjectMap.get(type)));
            }
        }
        result.append("-----");
        return result.toString();
    }
}

