/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.model.implementation;

import com.schneide.base.application.interaction.i18n.AbstractI18N;
import com.schneide.base.application.interaction.model.PermittableObject;
import com.schneide.base.application.interaction.model.Specification;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.util.EqualsBuilder;
import java.util.ArrayList;

public abstract class AbstractSpecification
extends LoggedObject
implements PermittableObject,
Specification,
EqualsBuilder.EqualComparable {
    private final String referenceName;
    private final boolean isInternal;
    private AbstractI18N resource;

    public AbstractSpecification(String referenceName, boolean isInternal) {
        this.referenceName = referenceName;
        this.isInternal = isInternal;
        this.resource = null;
    }

    protected void internalSetI18NResource(AbstractI18N newResource) {
        this.resource = newResource;
    }

    public Iterable<Object> getValuesToCompare() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.isInternal);
        result.add(this.referenceName);
        result.add((Object)this.resource);
        return result;
    }

    public int hashCode() {
        return EqualsBuilder.hashCodeFor((EqualsBuilder.EqualComparable)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.isEqual((EqualsBuilder.EqualComparable)this, (Object)obj);
    }

    @Override
    public String getDisplayText() {
        String result = null;
        if (this.resource != null) {
            result = this.resource.getDisplayText();
        }
        return result;
    }

    @Override
    public int getMnemonic() {
        int result = -1;
        if (this.resource != null) {
            result = this.resource.getMnemonic();
        }
        return result;
    }

    @Override
    public boolean hasMnemonic() {
        boolean result = false;
        if (this.resource != null) {
            result = this.resource.hasMnemonic();
        }
        return result;
    }

    protected AbstractI18N getI18NResource() {
        return this.resource;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }
}

