/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.handler;

import com.schneide.base.application.interaction.handler.AcceleratorUniquenessHandler;
import com.schneide.base.application.interaction.handler.MnemonicUniquenessHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class KeyboardShortcutUniquenessHandler {
    private final AcceleratorUniquenessHandler acceleratorHandler = this.createAcceleratorUniquenessHandlerFor();
    private final Map<String, MnemonicUniquenessHandler> mnemonicHandlerMap = new HashMap<String, MnemonicUniquenessHandler>();

    public MnemonicUniquenessHandler getMnemonicUniquenessHandlerFor(String context) {
        if (!this.mnemonicHandlerMap.containsKey(context)) {
            this.mnemonicHandlerMap.put(context, this.createMnemonicUniquenessHandlerFor(context));
        }
        return this.mnemonicHandlerMap.get(context);
    }

    protected AcceleratorUniquenessHandler createAcceleratorUniquenessHandlerFor() {
        return new AcceleratorUniquenessHandler();
    }

    protected MnemonicUniquenessHandler createMnemonicUniquenessHandlerFor(String context) {
        return new MnemonicUniquenessHandler(context);
    }

    public AcceleratorUniquenessHandler getAcceleratorUniquenessHandler() {
        return this.acceleratorHandler;
    }

    public String[] getMessagesFor(String context) throws NoSuchElementException {
        if (this.mnemonicHandlerMap.containsKey(context)) {
            return this.getMnemonicUniquenessHandlerFor(context).getMessages();
        }
        throw new NoSuchElementException("Das Element '" + context + " wurde nicht gefunden.");
    }

    public String[] getMessages() {
        ArrayList<String> messageList = new ArrayList<String>();
        messageList.addAll(Arrays.asList(this.acceleratorHandler.getMessages()));
        for (MnemonicUniquenessHandler element : this.mnemonicHandlerMap.values()) {
            messageList.addAll(Arrays.asList(element.getMessages()));
        }
        return messageList.toArray(new String[messageList.size()]);
    }
}

