/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction.handler;

import com.schneide.base.application.interaction.handler.AbstractUniquenessHandler;
import com.schneide.base.i18n.I18NText;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public class AcceleratorUniquenessHandler
extends AbstractUniquenessHandler {
    private final Map<KeyStroke, AcceleratorEntry> entryMap = new HashMap<KeyStroke, AcceleratorEntry>();

    public synchronized boolean checkAccelerator(KeyStroke accelerator, String menuItemDenotation, String menuDenotation) {
        if (accelerator == null) {
            return true;
        }
        if (this.entryMap.containsKey(accelerator)) {
            AcceleratorEntry entry = this.entryMap.get(accelerator);
            I18NText message = new I18NText("AcceleratorUniquenessHandler.message", new Object[]{menuItemDenotation, menuDenotation, this.getAcceleratorText(accelerator), entry.getItemDenotation(), entry.getMenuDenotation()});
            this.putMessage(message.resolvedText());
            return false;
        }
        this.entryMap.put(accelerator, new AcceleratorEntry(menuDenotation, menuItemDenotation));
        return true;
    }

    private String getAcceleratorText(KeyStroke accelerator) {
        int keyCode;
        if (accelerator == null) {
            return "";
        }
        StringBuffer acceleratorText = new StringBuffer("  <");
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText.append(InputEvent.getModifiersExText(modifiers));
            acceleratorText.append("+");
        }
        if ((keyCode = accelerator.getKeyCode()) != 0) {
            acceleratorText.append(KeyEvent.getKeyText(keyCode));
        } else {
            acceleratorText.append(accelerator.getKeyChar());
        }
        acceleratorText.append(">");
        return acceleratorText.toString();
    }

    private static class AcceleratorEntry {
        private final String menuDenotation;
        private final String itemDenotation;

        AcceleratorEntry(String menuDenotation, String itemDenotation) {
            this.menuDenotation = menuDenotation;
            this.itemDenotation = itemDenotation;
        }

        public String getItemDenotation() {
            return this.itemDenotation;
        }

        public String getMenuDenotation() {
            return this.menuDenotation;
        }
    }
}

