/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction;

import com.schneide.base.application.interaction.MenuActionHandler;
import com.schneide.base.application.interaction.MenuManager;
import com.schneide.base.application.interaction.PermissionUnit;
import com.schneide.base.application.interaction.configuration.MenuConfiguration;
import com.schneide.base.application.interaction.handler.AcceleratorUniquenessHandler;
import com.schneide.base.application.interaction.handler.EmptyKeyboardShortcutUniquenessHandler;
import com.schneide.base.application.interaction.handler.KeyboardShortcutUniquenessHandler;
import com.schneide.base.application.interaction.handler.MnemonicUniquenessHandler;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.interaction.model.MenuBarSpecification;
import com.schneide.base.application.interaction.model.MenuItemSpecification;
import com.schneide.base.application.interaction.model.MenuItemType;
import com.schneide.base.application.interaction.model.MenuSpecification;
import com.schneide.base.application.interaction.model.Specification;
import com.schneide.base.application.interaction.model.implementation.GenericMenuBarSpecification;
import com.schneide.base.application.interaction.model.implementation.SwingMenuSpecification;
import com.schneide.base.application.loaders.MenuSpecificationLoader;
import com.schneide.base.application.loaders.MenuSpecificationProvider;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.base.logging.LoggedObject;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class SwingMenuManager<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements MenuManager<S, U> {
    private static final String MENU_BAR = "Men\u00fcleiste";
    private final MenuSpecificationProvider<S, U> specificationProvider;

    public SwingMenuManager(ActionManager<S, U> actionManager, MenuConfiguration configuration) {
        this(new MenuSpecificationLoader<S, U>(actionManager, configuration));
    }

    public SwingMenuManager(MenuSpecificationProvider<S, U> specificationProvider) {
        this.specificationProvider = specificationProvider;
    }

    @Override
    public synchronized JMenuBar getMenuBarFor(PermissionUnit permissionUnit, MenuActionHandler<S, U> actionHandler) {
        return this.getMenuBarFor(permissionUnit, actionHandler, new EmptyKeyboardShortcutUniquenessHandler());
    }

    @Override
    public synchronized JMenuBar getMenuBarFor(PermissionUnit permissionUnit, MenuActionHandler<S, U> actionHandler, KeyboardShortcutUniquenessHandler uniquenessHandler) {
        JMenuBar result = new JMenuBar();
        MenuBarSpecification<S, U> specification = this.getMenuBarSpecificationFor(permissionUnit);
        String context = MENU_BAR;
        for (SwingMenuSpecification<S, U> element : specification.getMenus()) {
            JMenu menu = this.generateMenu(element, actionHandler, uniquenessHandler);
            if (this.checkMnemonic(element, uniquenessHandler, MENU_BAR)) {
                menu.setMnemonic(element.getMnemonic());
            }
            result.add(menu);
        }
        return result;
    }

    protected JMenu generateMenu(SwingMenuSpecification<S, U> menuSpecification, MenuActionHandler<S, U> actionHandler, KeyboardShortcutUniquenessHandler uniquenessHandler) {
        JMenu result = new JMenu(menuSpecification.getDisplayText());
        Iterable<MenuItemSpecification<S, U>> menuItemSpecifications = menuSpecification.getMenuItems();
        for (MenuItemSpecification<S, U> element : menuItemSpecifications) {
            JMenuItem item = element.getMenuItemType().getMenuItem();
            this.setupMenuItem(item, menuSpecification, actionHandler, uniquenessHandler, element);
            result.add(item.getComponent());
        }
        return result;
    }

    private void setupMenuItem(JMenuItem item, SwingMenuSpecification<S, U> menuSpecification, MenuActionHandler<S, U> actionHandler, KeyboardShortcutUniquenessHandler uniquenessHandler, MenuItemSpecification<S, U> element) {
        if (item instanceof MenuItemType.MenuSeparator) {
            return;
        }
        item.setAction(actionHandler.getActionFor(element));
        item.setText(element.getDisplayText());
        item.setIcon(element.getIcon());
        if (this.checkMnemonic(element, uniquenessHandler, menuSpecification.getDisplayText())) {
            item.setMnemonic(element.getMnemonic());
        }
        if (this.checkAccelerator(element, uniquenessHandler, menuSpecification.getDisplayText())) {
            item.setAccelerator(element.getAccelerator());
        }
    }

    protected boolean checkMnemonic(Specification specification, KeyboardShortcutUniquenessHandler uniquenessHandler, String context) {
        MnemonicUniquenessHandler mnemonicHandler = uniquenessHandler.getMnemonicUniquenessHandlerFor(context);
        if (specification.hasMnemonic()) {
            return mnemonicHandler.checkMnemonic(specification.getMnemonic(), specification.getDisplayText());
        }
        return true;
    }

    protected boolean checkAccelerator(MenuItemSpecification<?, ?> menuItemSpecification, KeyboardShortcutUniquenessHandler uniquenessHandler, String context) {
        AcceleratorUniquenessHandler acceleratorHandler = uniquenessHandler.getAcceleratorUniquenessHandler();
        return acceleratorHandler.checkAccelerator(menuItemSpecification.getAccelerator(), menuItemSpecification.getDisplayText(), context);
    }

    @Override
    public MenuBarSpecification<S, U> getMenuBarSpecificationFor(PermissionUnit permissionUnit) {
        return this.getMenuBarSpecificationFor(permissionUnit, new EmptyKeyboardShortcutUniquenessHandler());
    }

    @Override
    public MenuBarSpecification<S, U> getMenuBarSpecificationFor(PermissionUnit permissionUnit, KeyboardShortcutUniquenessHandler uniquenessHandler) {
        GenericMenuBarSpecification<S, U> result = new GenericMenuBarSpecification<S, U>();
        Iterable<SwingMenuSpecification<S, U>> menuSpecifications = this.specificationProvider.getMenuSpecification().getMenus();
        for (SwingMenuSpecification<S, U> menuSpecification : menuSpecifications) {
            SwingMenuSpecification<S, U> newMenuSpecification = menuSpecification.getCopyWithoutChildren();
            Iterable<MenuItemSpecification<S, U>> currentlyAllowedMenuItems = this.getMenuItemSpecificationsFor(permissionUnit, menuSpecification, uniquenessHandler);
            for (MenuItemSpecification<S, U> specification : currentlyAllowedMenuItems) {
                newMenuSpecification.addMenuItem(specification);
            }
            if (!this.isNeededWithinMenuBar(permissionUnit, newMenuSpecification)) continue;
            this.checkMnemonic(newMenuSpecification, uniquenessHandler, MENU_BAR);
            result.addMenu(newMenuSpecification);
        }
        return result;
    }

    private boolean isNeededWithinMenuBar(PermissionUnit permissionUnit, SwingMenuSpecification<S, U> menuSpecification) {
        return !IterableUtil.isEmpty(menuSpecification.getMenuItems()) || permissionUnit.isPermitted(menuSpecification);
    }

    private boolean isLastOf(MenuItemSpecification<S, U> specification, Iterable<MenuItemSpecification<S, U>> fullContent) {
        int lastIndex = IterableUtil.getSizeFor(fullContent) - 1;
        return specification.equals(IterableUtil.getElementAt((int)lastIndex, fullContent));
    }

    protected Iterable<MenuItemSpecification<S, U>> getMenuItemSpecificationsFor(PermissionUnit permissionUnit, MenuSpecification<S, U> menuSpecification, KeyboardShortcutUniquenessHandler shortcutUniquenessHandler) {
        Iterable<MenuItemSpecification<S, U>> fullContent = menuSpecification.getMenuItems();
        ArrayList<MenuItemSpecification<S, U>> result = new ArrayList<MenuItemSpecification<S, U>>();
        boolean isSuccessorOfSeparator = true;
        for (MenuItemSpecification<S, U> specification : fullContent) {
            if (MenuItemType.SEPARATOR.equals((Object)specification.getMenuItemType())) {
                if (!isSuccessorOfSeparator && !this.isLastOf(specification, fullContent)) {
                    result.add(specification);
                }
                isSuccessorOfSeparator = true;
                continue;
            }
            if (!permissionUnit.isPermitted(specification)) continue;
            this.checkMnemonic(specification, shortcutUniquenessHandler, menuSpecification.getDisplayText());
            this.checkAccelerator(specification, shortcutUniquenessHandler, menuSpecification.getDisplayText());
            result.add(specification);
            isSuccessorOfSeparator = false;
        }
        return result;
    }

    @Override
    public MenuBarSpecification<S, U> getMenuBarSpecification() {
        return this.getMenuBarSpecificationFor(permittableObject -> true);
    }
}

