/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.interaction;

import com.schneide.base.application.interaction.configuration.ActionLoaderConfiguration;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.interaction.model.ActionSpecification;
import com.schneide.base.application.interaction.model.ActionsSpecification;
import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.application.interaction.model.InvocationSelectionMode;
import com.schneide.base.application.interaction.model.implementation.ActionSpecificationContainer;
import com.schneide.base.application.loaders.ActionSpecificationLoader;
import com.schneide.base.application.process.generic.ProcessActivationMethod;
import com.schneide.base.application.process.generic.SchneideAction;
import com.schneide.base.application.process.generic.SwingSchneideAction;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.logging.LoggedObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ConfiguredActionManager<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements ActionManager<S, U> {
    private final ActionSpecificationLoader<S, U> loader;
    private final ActivationContextProvider contextProvider;

    public ConfiguredActionManager(ActionLoaderConfiguration configuration, ActivationContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.loader = new ActionSpecificationLoader(configuration);
        try {
            this.loader.load();
        }
        catch (IOException e) {
            this.getLogger().fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Iterable<String> getAllActionReferences() {
        return Arrays.asList(this.getActionReferences());
    }

    @Override
    public SchneideAction<S, U> getAction(String reference, S session, ProcessActivationMethod entranceSpecification, Object ... temporaryParameters) throws NoSuchElementException {
        return this.getAction(reference, session, "", entranceSpecification, temporaryParameters);
    }

    @Override
    public SchneideAction<S, U> getAction(String reference, S session, String title, ProcessActivationMethod entranceSpecification, Object ... temporaryParameters) throws NoSuchElementException {
        ActionSpecification<S, U> specification = this.getLoader().getActionSpecification(reference);
        return new SwingSchneideAction(session, specification.getTargetProcess(session), title, specification.getProcessDisplayName(), this.getContextProvider(), entranceSpecification, temporaryParameters);
    }

    private ActionSpecificationLoader<S, U> getLoader() {
        return this.loader;
    }

    private ActivationContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public String[] getActionReferences() {
        return this.loader.getActionReferences();
    }

    @Override
    public Thread performAction(String actionReference, S session) {
        return this.performAction(actionReference, session, InvocationSelectionMode.TOGGLE_ENABLED);
    }

    @Override
    public Thread performAction(String actionReference, S session, InvocationSelectionMode startType) {
        return this.getAction(actionReference, session, ProcessActivationMethod.USER_STARTED, new Object[0]).perform(startType);
    }

    @Override
    public Thread performAction(String actionReference, S session, Object ... temporaryParameters) {
        return this.getAction(actionReference, session, ProcessActivationMethod.USER_STARTED, new Object[0]).perform(temporaryParameters);
    }

    @Override
    public ActionsSpecification<S, U> getActionReferenceSpecification() {
        ActionSpecificationContainer<S, U> actionsSpecification = new ActionSpecificationContainer<S, U>(new EmptyIterable());
        for (String actionReference : this.getActionReferences()) {
            actionsSpecification.addActionSpecification(this.loader.getActionSpecification(actionReference));
        }
        return actionsSpecification;
    }
}

