/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.ux;

import java.awt.AWTKeyStroke;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class KeyboardUX {
    private KeyboardUX() {
    }

    public static void enableAltKeyMenuFor(JFrame frame) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> KeyboardUX.enableAltKeyMenuFor(frame));
            return;
        }
        String highlightingKey = "highlight_menu";
        final JRootPane rootPane = frame.getRootPane();
        InputMap inputMap = rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(18, 0, true), "highlight_menu");
        AbstractAction highlightMenuAction = new AbstractAction(){
            private static final long serialVersionUID = 9001583484241420215L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuBar menuBar = rootPane.getJMenuBar();
                JMenu menu = menuBar.getMenu(0);
                menu.doClick();
            }
        };
        rootPane.getActionMap().put("highlight_menu", highlightMenuAction);
    }

    public static void enableModernFocusTraversal() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(KeyboardUX::enableModernFocusTraversal);
            return;
        }
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        KeyboardUX.addLeftAndRightArrowAsFocusKeys();
    }

    private static void addLeftAndRightArrowAsFocusKeys() {
        KeyboardUX.addFocusKey(AWTKeyStroke.getAWTKeyStroke("RIGHT"), 0);
        KeyboardUX.addFocusKey(AWTKeyStroke.getAWTKeyStroke("LEFT"), 1);
    }

    private static void addFocusKey(AWTKeyStroke key, int focusTraversalId) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Set<AWTKeyStroke> forwardKeys = focusManager.getDefaultFocusTraversalKeys(focusTraversalId);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(key);
        focusManager.setDefaultFocusTraversalKeys(focusTraversalId, newForwardKeys);
    }
}

