/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.monitor;

import com.schneide.base.eventbus.inspection.InspectableEventBus;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.io.reader.LineBuilder;
import com.schneide.base.threading.SchneideThread;
import com.schneide.base.threading.executor.DoInBackground;
import java.awt.TextArea;
import javax.swing.JFrame;

public class EventBusSubscribersWindow {
    private final InspectableEventBus applicationBus;
    private final TextArea list;

    public EventBusSubscribersWindow(InspectableEventBus applicationBus) {
        this.applicationBus = applicationBus;
        this.list = (TextArea)EDT.query(() -> {
            TextArea result = new TextArea(50, 60);
            result.setEditable(false);
            return result;
        });
    }

    public void show() {
        EDT.performBlocking(() -> {
            JFrame frame = new JFrame("EventBus subscribers");
            frame.getContentPane().add(this.list);
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setVisible(true);
        });
        DoInBackground.now((String)"eventbus subscribers display", () -> {
            while (true) {
                LineBuilder subscribers = new LineBuilder();
                this.applicationBus.onSubscriptions(nr -> subscribers.addLine(nr.getClass().getSimpleName() + " for " + nr.expectedNewsType().getSimpleName() + " @" + nr.hashCode()));
                EDT.perform(() -> this.list.setText(subscribers.getText()));
                SchneideThread.performDelay((long)1000L);
            }
        });
    }
}

