/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.about;

import com.schneide.base.configuration.ReadConfiguration;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.system.Base;
import com.schneide.base.text.buffer.ChunkBuffer;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;

class SchneideAboutConfiguration
extends ReadConfiguration {
    public SchneideAboutConfiguration(ChunkBuffer configLines) {
        super((Reader)new StringReader(configLines.toString()), new I18NKey("SchneideAboutConfiguration.title").resolvedText());
    }

    public String getDescription() {
        return this.parseStringProperty("application.description");
    }

    public String getHomepageLink() {
        return this.parseStringProperty("application.homepage.url");
    }

    public ImageIcon getApplicationLogo() {
        try {
            return new ImageIcon(this.parseFileProperty("application.logo").toURI().toURL());
        }
        catch (MalformedURLException e) {
            Base.getDefaultLogger().error((Object)"Applikationslogo konnte nicht gefunden werden.", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            Base.getDefaultLogger().error((Object)"Applikationslogo konnte nicht gelesen werden.", (Throwable)e);
        }
        return new ImageIcon();
    }

    public ImageIcon getManufacturerLogo() {
        try {
            return new ImageIcon(this.parseFileProperty("manufacturer.logo").toURI().toURL());
        }
        catch (MalformedURLException e) {
            Base.getDefaultLogger().error((Object)"Herstellerlogo konnte nicht gefunden werden.", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            Base.getDefaultLogger().error((Object)"Herstellerlogo konnte nicht gelesen werden.", (Throwable)e);
        }
        return new ImageIcon();
    }
}

