/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui.about;

import com.schneide.base.application.ApplicationInformation;
import com.schneide.base.application.gui.about.AboutInformation;
import com.schneide.base.application.gui.about.VersionTooltipProvider;
import com.schneide.base.application.version.Version;
import com.schneide.base.gui.ImageLabel;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import com.schneide.base.layout.tablelayout.StringTableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog
extends AbstractSchneideDialog<Void> {
    private final AboutInformation information;

    public AboutDialog(WindowStack session, AboutInformation information) {
        super(session, (I18NKeyed)new I18NKey("AboutDialog"));
        this.information = information;
    }

    protected void buildUI() {
        this.setTitle(this.getTextEntry("title", new Object[]{this.information.getInformation().getName()}));
        this.addButton().closeButton();
        JPanel contentPanel = new JPanel();
        int iconColumnWidth = Math.max(this.information.getApplicationLogo().getIconWidth(), this.information.getManufacturerLogo().getIconWidth());
        int teamLines = this.information.getTeam().length;
        StringBuilder columnsSpecification = new StringBuilder();
        columnsSpecification.append(iconColumnWidth);
        columnsSpecification.append(", (10), FILL");
        StringBuilder rowsSpecification = new StringBuilder();
        rowsSpecification.append("PREFERRED, (5), PREFFERED, (30), PREFERRED, (10)");
        for (int i = 0; i < teamLines; ++i) {
            rowsSpecification.append(", PREFERRED, (5)");
        }
        StringTableLayout tableLayout = new StringTableLayout(columnsSpecification.toString(), rowsSpecification.toString());
        contentPanel.setLayout((LayoutManager)tableLayout);
        ImageLabel applicationLogo = new ImageLabel(this.information.getApplicationLogo());
        this.addVersionTooltipTo((JComponent)applicationLogo, this.information.getInformation().getVersion());
        contentPanel.add("column=0, row=0, anchor=NORTHWEST, width=1, height=2", (Component)applicationLogo);
        JLabel titleLabel = this.buildTitleLabel(this.information.getInformation());
        contentPanel.add("column=1, row=0, anchor=WEST", titleLabel);
        JLabel descriptionLabel = new JLabel(this.information.getDescription());
        this.addVersionTooltipTo(descriptionLabel, this.information.getInformation().getVersion());
        contentPanel.add("column=1, row=1, anchor=NORTHWEST", descriptionLabel);
        JLabel producedByLabel = new JLabel(new I18NKey("AboutDialog.producedBy").resolvedText());
        producedByLabel.setFont(producedByLabel.getFont().deriveFont(1));
        contentPanel.add("column=0, row=2, anchor=WEST, width=2, height=1", producedByLabel);
        ImageLabel manufacturerLogo = new ImageLabel(this.information.getManufacturerLogo());
        manufacturerLogo.setToolTipText(new I18NKey("AboutDialog.logo.manufacturer.tooltip").resolvedText());
        contentPanel.add("column=0, row=3, anchor=NORTHWEST, width=1, height=" + teamLines, (Component)manufacturerLogo);
        String[] teamMembers = this.information.getTeam();
        for (int i = 0; i < teamMembers.length; ++i) {
            contentPanel.add("column=1, row=" + (i + 3) + ", anchor=WEST", new JLabel(teamMembers[i]));
        }
        this.setContent(contentPanel);
    }

    protected void addVersionTooltipTo(JComponent label, Version version) {
        label.setToolTipText(new VersionTooltipProvider().getTooltipFor(version));
    }

    protected JLabel buildTitleLabel(ApplicationInformation applicationInformation) {
        JLabel titleLabel = new JLabel(applicationInformation.getDescription());
        this.addVersionTooltipTo(titleLabel, applicationInformation.getVersion());
        Font normalFont = titleLabel.getFont();
        titleLabel.setFont(normalFont.deriveFont((float)(normalFont.getSize() + 5)));
        return titleLabel;
    }

    protected Optional<Void> giveAnswer() {
        return Optional.empty();
    }
}

