/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.gui;

import com.schneide.base.application.gui.model.FrameVisualisationSpecification;
import com.schneide.base.application.gui.news.ApplicationFrameClosed;
import com.schneide.base.application.gui.ux.KeyboardUX;
import com.schneide.base.application.interaction.MenuActionHandler;
import com.schneide.base.application.interaction.MenuManager;
import com.schneide.base.application.interaction.model.MenuItemSpecification;
import com.schneide.base.application.process.generic.SchneideAction;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.statusbar.SimpleStatusbarManager;
import com.schneide.base.application.statusbar.StatusbarManager;
import com.schneide.base.application.usermanagement.data.UserPermissionUnit;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.eventbus.News;
import com.schneide.base.gui.Resize;
import com.schneide.base.gui.swing.EDT;
import com.schneide.base.lifecycle.LifeCycle;
import com.schneide.base.lifecycle.dependent.DependentResourcesHost;
import com.schneide.base.lifecycle.dependent.DisposeDependentResources;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.maths.Percent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class SchneideApplicationFrame<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements WindowListener,
MenuActionHandler<S, U>,
DependentResourcesHost {
    public static final String FRAME_NAME = "frame.mainFrame";
    private final JFrame frame;
    private final JPanel contentPanel;
    private final S session;
    private final MenuManager<S, U> menuManager;
    private final UserManager<U> userManager;
    private final List<LifeCycle> dependent;
    private StatusbarManager statusbarManager;
    private boolean wasUIBuilt;

    public SchneideApplicationFrame(S session, FrameVisualisationSpecification visualisationSpecification, MenuManager<S, U> menuManager, UserManager<U> userManager) {
        EDT.only();
        this.dependent = new LinkedList<LifeCycle>();
        this.wasUIBuilt = false;
        this.frame = SchneideApplicationFrame.buildMainFrameInstanceWith(visualisationSpecification.getTitle());
        this.frame.setIconImage(visualisationSpecification.getIcon().getImage());
        this.contentPanel = new JPanel();
        this.frame.setContentPane(this.contentPanel);
        this.session = session;
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.statusbarManager = new SimpleStatusbarManager(session);
        this.menuManager = menuManager;
        this.userManager = userManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(LifeCycle resource) {
        List<LifeCycle> list = this.dependent;
        synchronized (list) {
            this.dependent.add(resource);
        }
    }

    public static JFrame buildMainFrameInstanceWith(String title) {
        JFrame result = new JFrame(title);
        result.setName(FRAME_NAME);
        return result;
    }

    public StatusbarManager getStatusbarManager() {
        return this.statusbarManager;
    }

    protected void setStatusbarManager(StatusbarManager statusbarManager) {
        this.statusbarManager = statusbarManager;
    }

    protected void buildUI() {
        this.rebuildMenu();
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.getStatusbarManager().getStatusBar(), "South");
    }

    protected void rebuildMenu() {
        this.getLogger().info((Object)("Building menu with " + String.valueOf(this.getUserManager())));
        this.frame.setJMenuBar(this.menuManager.getMenuBarFor(new UserPermissionUnit<U>(this.getUserManager(), this.getSession().getUser()), this));
        KeyboardUX.enableAltKeyMenuFor(this.frame);
    }

    protected UserManager<U> getUserManager() {
        return this.userManager;
    }

    protected S getSession() {
        return this.session;
    }

    public void hideFrame() {
        this.setVisible(false);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            if (!this.wasUIBuilt) {
                this.buildUI();
                this.wasUIBuilt = true;
            }
            this.session.showWindow(this.frame);
        } else {
            this.session.hideWindow(this.frame);
        }
        this.frame.setVisible(isVisible);
    }

    public void showFrameWithoutResizing() {
        this.setVisible(true);
    }

    public void showFrame() {
        this.showFrame(Percent.oneHundred, Percent.oneHundred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.hideFrame();
        this.frame.dispose();
        this.getSession().getApplicationBus().publish((News)new ApplicationFrameClosed());
        List<LifeCycle> list = this.dependent;
        synchronized (list) {
            DisposeDependentResources.givenAsLifecycle(this.dependent);
        }
    }

    public Resize.ResizeFrame resize() {
        return Resize.frame((Frame)this.frame);
    }

    public void showFrame(Percent relativeWidth, Percent relativeHeight) {
        this.showFrame(relativeWidth.getAsFactor(), relativeHeight.getAsFactor(), false);
    }

    public void showFrame(Percent relativeWidth, Percent relativeHeight, boolean isMaximized) {
        Resize.ResizeFrame resizeFrame = (Resize.ResizeFrame)((Resize.ResizeFrame)this.resize().horizontally(relativeWidth)).vertically(relativeHeight);
        if (isMaximized) {
            resizeFrame.maximize();
        }
        this.showFrameWithoutResizing();
    }

    public void showFrame(double horizontalAspectRatio, double verticalAspectRatio, boolean isMaximized) {
        this.showFrame(Percent.fromFactor((double)horizontalAspectRatio), Percent.fromFactor((double)verticalAspectRatio), isMaximized);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.dispose();
    }

    @Override
    public abstract void windowClosing(WindowEvent var1);

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public SchneideAction<S, U> getActionFor(MenuItemSpecification<S, U> menuItem) {
        return menuItem.getAction(this.getSession());
    }

    protected JFrame getFrame() {
        return this.frame;
    }

    public void setFrameName(String newName) {
        EDT.performBlocking(() -> this.getFrame().setName(newName));
    }
}

