/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.dialog.module;

import com.schneide.base.application.module.ApplicationModule;
import com.schneide.base.application.module.ModuleMode;
import com.schneide.base.application.module.ModuleSpecification;
import com.schneide.base.application.periphery.ModuleRepository;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.icon.IconProvider;
import com.schneide.base.i18n.DirectText;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import java.awt.Container;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.dev.designgridlayout.DesignGridLayout;

public class ModuleOverviewDialog
extends AbstractSchneideDialog<Void> {
    private final ModuleRepository modules;

    public ModuleOverviewDialog(SchneideSession<? extends SchneideUser> session, ModuleRepository modules) {
        super(session.getMainWindowStack(), (I18NKeyed)new I18NKey("ModuleOverviewDialog"));
        this.modules = modules;
    }

    protected void buildUI() {
        this.addMessage(this.getTextEntry("message"));
        JPanel content = new JPanel();
        DesignGridLayout grid = new DesignGridLayout((Container)content);
        for (ApplicationModule<?> each : this.modules.all()) {
            ModuleSpecification module = each.specification();
            ModuleMode currentMode = module.getMode();
            JLabel denotation = new JLabel(module.getDenotation());
            JLabel icon = new JLabel(module.moduleIcon().icon());
            JLabel modeTitle = new JLabel(new DirectText("Aktueller Betriebsmodus:").text());
            JLabel modeIcon = new JLabel(((IconProvider)currentMode.modeIcon().apply((Object)each.specification().getIdentifier())).icon());
            JLabel modeDenotation = new JLabel(currentMode.getDenotation());
            grid.row().grid(denotation).add(new JComponent[]{icon}).add(new JComponent[]{modeTitle}).add(new JComponent[]{modeIcon}).add(new JComponent[]{modeDenotation});
            grid.emptyRow();
        }
        this.setContent(content);
        this.addButton().closeButton();
    }

    protected Optional<Void> giveAnswer() {
        return Optional.empty();
    }
}

