/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.data;

import com.schneide.base.application.data.BugReport;
import com.schneide.base.text.TextBuffer;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DetailedBugReport
implements BugReport {
    private final Date reportDate;
    private final String reporterName;
    private final String reporterEmailAddress;
    private final String product;
    private final String version;
    private final String instance;
    private final String summary;
    private final String description;
    private final String severity;
    private final File systemPropertiesPack;
    private final File logfilePack;
    private final File configurationFilesPack;

    public DetailedBugReport(Date reportDate, String reporterName, String reporterEmailAddress, String product, String version, String instance, String summary, String description, String severity, File systemProperties, File logfilePack, File configurationFilesPack) {
        this.reportDate = reportDate;
        this.reporterName = reporterName;
        this.reporterEmailAddress = reporterEmailAddress;
        this.product = product;
        this.version = version;
        this.instance = instance;
        this.summary = summary;
        this.description = description;
        this.severity = severity;
        this.systemPropertiesPack = systemProperties;
        this.logfilePack = logfilePack;
        this.configurationFilesPack = configurationFilesPack;
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    protected static DateFormat getIndexFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public String getReportIdentifier() {
        return DetailedBugReport.getReportIdentifierFor(this.getReportDate());
    }

    public static String getReportIdentifierFor(Date date) {
        return DetailedBugReport.getIndexFormat().format(date);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public File getLogfilePack() {
        return this.logfilePack;
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    @Override
    public Date getReportDate() {
        return this.reportDate;
    }

    @Override
    public String getReporterEmailAddress() {
        return this.reporterEmailAddress;
    }

    @Override
    public String getReporterName() {
        return this.reporterName;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public File getSystemProperties() {
        return this.systemPropertiesPack;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public File getConfigurationFilesPack() {
        return this.configurationFilesPack;
    }

    public String toString() {
        TextBuffer buffer = new TextBuffer();
        this.addLineToBuffer(buffer, "Date", DetailedBugReport.getDateFormat().format(this.getReportDate()));
        this.addLineToBuffer(buffer, "Reporter", this.getReporterName());
        this.addLineToBuffer(buffer, "Reporter Email", this.getReporterEmailAddress());
        buffer.addln("");
        this.addLineToBuffer(buffer, "Product", this.getProduct());
        this.addLineToBuffer(buffer, "Version", this.getVersion());
        this.addLineToBuffer(buffer, "Instance", this.getInstance());
        buffer.addln("");
        this.addLineToBuffer(buffer, "Severity", this.getSeverity());
        this.addLineToBuffer(buffer, "Summary", this.getSummary());
        this.addLineToBuffer(buffer, "Description", this.getDescription());
        buffer.addln("");
        buffer.addln("--------------------------------------------");
        this.addLineToBuffer(buffer, "Local path to System parameters", this.getSystemProperties());
        this.addLineToBuffer(buffer, "Local path to Configuration", this.getConfigurationFilesPack());
        this.addLineToBuffer(buffer, "Local path to Logfiles", this.getLogfilePack());
        return buffer.toString();
    }

    private void addLineToBuffer(TextBuffer buffer, String title, File file) {
        this.addLineToBuffer(buffer, title, file.getAbsolutePath());
    }

    private void addLineToBuffer(TextBuffer buffer, String title, String text) {
        buffer.add(title);
        buffer.add(": ");
        buffer.addln(text);
    }
}

