/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crypt;

import com.schneide.base.application.crypt.EncryptionException;
import com.schneide.base.util.Parameter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public final class CryptographyService {
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final String CHARSET = "ascii";

    private CryptographyService() {
    }

    public static String getBase64EncodedDigestOf(String plainText) throws EncryptionException {
        try {
            String digest = CryptographyService.getEncryptedText(plainText);
            return CryptographyService.encodeBase64(digest);
        }
        catch (EncryptionException e) {
            throw new EncryptionException("Could not encrypt plain text.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException("Could not encrypt to UTF-8 string.", e);
        }
    }

    public static String encodeBase64(String text) throws UnsupportedEncodingException {
        byte[] base64 = Base64.encodeBase64((byte[])text.getBytes(CHARSET));
        return new String(base64, CHARSET);
    }

    public static String getEncryptedText(String plainText) throws EncryptionException {
        Parameter.isPresent((Object)plainText);
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITHM);
            digest.update(plainText.getBytes(CHARSET));
            return new String(digest.digest(), CHARSET);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Could not encrypt plain text.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException("Could not encrypt to UTF-8 string.", e);
        }
    }
}

