/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui.standard;

import com.schneide.base.application.crud.CreationException;
import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudModel;
import com.schneide.base.application.crud.ValueMapper;
import com.schneide.base.application.crud.gui.CreationDialog;
import com.schneide.base.application.crud.gui.CrudDialogFactory;
import com.schneide.base.application.crud.gui.GenericButtonPanel;
import com.schneide.base.application.crud.gui.GenericButtonSpecification;
import com.schneide.base.application.crud.gui.UpdateDialog;
import com.schneide.base.application.crud.gui.standard.CrudContext;
import com.schneide.base.application.crud.gui.standard.StandardRightsProvider;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.datatypes.collections.iterable.EmptyIterable;
import com.schneide.base.gui.dialog.defaults.DefaultDialog;
import com.schneide.base.gui.dialog.defaults.QuestionDialog;
import com.schneide.base.gui.i18n.DefaultI18NDisplayInformation;
import com.schneide.base.gui.i18n.DisplayInformation;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.I18NText;
import com.schneide.base.i18n.model.I18NResolvable;
import com.schneide.base.system.Base;

public class StandardCrudButtonPanel<E extends CrudElement<I>, I>
extends GenericButtonPanel<E, I> {
    private static final long serialVersionUID = 4010839791836377374L;
    private final SchneideSession<?> session;
    private final WindowStack windowStack;
    private final CrudContext<E, I> context;

    public StandardCrudButtonPanel(SchneideSession<?> session, I18NKey baseKey, CrudContext<E, I> context, StandardRightsProvider rightsProvider) {
        this(session, session.getMainWindowStack(), baseKey, context, rightsProvider);
    }

    public StandardCrudButtonPanel(SchneideSession<?> session, WindowStack windowStack, I18NKey baseKey, CrudContext<E, I> context, StandardRightsProvider rightsProvider) {
        super(session, new EmptyIterable());
        this.session = session;
        this.windowStack = windowStack;
        this.context = context;
        this.addButton(new GenericButtonSpecification((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(baseKey.withKeyPart("button.create"), new Object[]{this.getItemTypeDenotation()})), selectedElement -> {
            this.createNewContentObject();
            return false;
        }, rightsProvider.getCreateRight(), false, true));
        this.addButton(new GenericButtonSpecification((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(baseKey.withKeyPart("button.edit"), new Object[]{this.getItemTypeDenotation()})), selectedElement -> {
            this.updateSelectedContentObject(selectedElement);
            return false;
        }, rightsProvider.getEditRight(), true, false));
        this.addButton(new GenericButtonSpecification((DisplayInformation)new DefaultI18NDisplayInformation((I18NResolvable)new I18NText(baseKey.withKeyPart("button.delete"), new Object[]{this.getItemTypeDenotation()})), selectedElement -> {
            this.deleteSelectedContentObject(selectedElement);
            return false;
        }, rightsProvider.getDeleteRight(), true, false));
    }

    private I18NKey getLevelFullKey(String partialKey) {
        return I18NKey.buildFromParts((String[])new String[]{"GenericElementManagementView", partialKey});
    }

    protected CrudDialogFactory<E, I> getDialogFactory() {
        return this.context.getDialogFactory();
    }

    protected ValueMapper<E, I> getValueMapper() {
        return this.context.getValueMapper();
    }

    protected String getItemTypeDenotation() {
        return this.context.getItemTypeDenotation();
    }

    public void createNewContentObject() {
        try {
            CreationDialog<E, I> dialog = this.getDialogFactory().createCreationDialog(this.session, this.getWindowStack(), this.getModel(), this.getValueMapper());
            dialog.showDialog();
            if (dialog.wasClosedByCommit()) {
                E element = dialog.createElement();
                this.getModel().addElement(element);
                this.getView().elementAdded(element);
            }
        }
        catch (CreationException e) {
            DefaultDialog.showErrorDialog((WindowStack)this.getWindowStack(), (I18NKey)this.getLevelFullKey("error.create.object"), (Object[])new Object[]{e.getMessage()});
            Base.getLogger((Object)this).error((Object)("Error while creating a " + this.getItemTypeDenotation()), (Throwable)e);
        }
    }

    public void deleteSelectedContentObject(E element) {
        boolean deleteConfirmed = QuestionDialog.showYesNoDecisionDialog((WindowStack)this.getWindowStack(), (I18NKey)this.getLevelFullKey("question.remove.object"), (Object[])new Object[]{this.getItemTypeDenotation(), element.getDenotation()});
        if (deleteConfirmed) {
            int index = this.getModel().indexOf(element);
            this.getModel().deleteElement(element);
            this.getView().elementDeleted(element, index);
        }
    }

    public void updateSelectedContentObject(E element) {
        Object oldDenotation = element.getIdentifier();
        UpdateDialog<E, I> dialog = this.getDialogFactory().createUpdateDialog(this.session, this.getWindowStack(), element, this.getValueMapper());
        dialog.showDialog();
        if (dialog.wasClosedByCommit()) {
            dialog.updateElement();
            this.getModel().updateElement(oldDenotation, dialog.getElement());
            this.getView().elementUpdated(dialog.getElement());
            this.getView().elementUpdated(element);
        }
    }

    public WindowStack getWindowStack() {
        return this.windowStack;
    }

    public CrudModel<E, I> getModel() {
        return this.context.getModel();
    }
}

