/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudModel;
import com.schneide.base.application.crud.DisplayInformationProvider;
import com.schneide.base.application.crud.gui.GenericElementTableModel;
import com.schneide.base.application.crud.gui.SelectableElementView;
import com.schneide.base.gui.component.SchneideTable;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.logging.Logger;
import com.schneide.base.system.Base;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;

public class GenericTableView<E extends CrudElement<I>, I>
extends JPanel
implements SelectableElementView<E, I> {
    private static final long serialVersionUID = 7416558943229036026L;
    private SchneideTable selectionTable;
    private final GenericElementTableModel<E, I> tableModel;

    public GenericTableView(CrudModel<E, I> model, DisplayInformationProvider<E, I> valueMapper) {
        super((LayoutManager)new StringGridBagLayout());
        this.tableModel = new GenericElementTableModel<E, I>(model, valueMapper);
        model.addModelChangeListener(this.tableModel);
        this.buildUI();
    }

    private void buildUI() {
        this.selectionTable = new SchneideTable(this.tableModel);
        this.selectionTable.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane((Component)this.selectionTable);
        this.add("anchor=SOUTH,gridx=0,gridy=0,fill=BOTH,weighty=1,insets=[5,0,5,0]", scrollPane);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionTable.getSelectionModel().addListSelectionListener(listener);
    }

    protected SchneideTable getTable() {
        return this.selectionTable;
    }

    protected GenericElementTableModel<E, I> getTableModel() {
        return this.tableModel;
    }

    @Override
    public int getSelectedIndex() {
        return this.getTable().getSelectedIndex();
    }

    @Override
    public E getSelectedElement() {
        if (this.getTable().getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        return this.getElementAt(this.getSelectedIndex());
    }

    @Override
    public E getElementAt(int index) {
        return this.tableModel.getElementAt(index);
    }

    @Override
    public int getIndexOf(E element) {
        return this.tableModel.getSortedEntries().indexOf(element);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.getTable().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public void elementInserted(E element) {
        SwingUtilities.invokeLater(() -> {
            int index = this.getIndexOf(element);
            this.getTableModel().fireTableRowsInserted(index, index);
        });
    }

    @Override
    public void elementDeleted(E element, int index) {
        SwingUtilities.invokeLater(() -> this.getTableModel().fireTableRowsDeleted(index, index));
    }

    @Override
    public void elementUpdated(E element) {
        SwingUtilities.invokeLater(() -> {
            int index = this.getIndexOf(element);
            this.getLogger().debug((Object)("updated at index " + index));
            this.getTableModel().fireTableRowsUpdated(index, index);
        });
    }

    protected Logger getLogger() {
        return Base.getLogger((Object)this);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void refresh() {
        SwingUtilities.invokeLater(() -> this.getTableModel().fireTableDataChanged());
    }
}

