/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.CrudButtonPanel;
import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudModel;
import com.schneide.base.application.crud.gui.ElementManagementView;
import com.schneide.base.application.crud.gui.SelectableElementView;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.layout.StringGridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class GenericElementManagementView<E extends CrudElement<I>, I>
extends JPanel
implements ElementManagementView<E, I> {
    private static final long serialVersionUID = -5433247265841182019L;
    private final CrudModel<E, I> model;
    private final SelectableElementView<E, I> selectableElementView;
    private final CrudButtonPanel<E, I> buttonPanel;
    private final WindowStack session;

    public GenericElementManagementView(WindowStack session, SelectableElementView<E, I> selectableElementView, CrudButtonPanel<E, I> buttonPanel, CrudModel<E, I> model) {
        super((LayoutManager)new StringGridBagLayout());
        this.model = model;
        this.session = session;
        this.selectableElementView = selectableElementView;
        this.buttonPanel = buttonPanel;
        this.buildUI();
    }

    protected void buildUI() {
        this.selectableElementView.addListSelectionListener(e -> this.buttonPanel.updateState(!this.getSelectableElementView().isSelectionEmpty()));
        this.buttonPanel.setView(this);
        this.add("anchor=SOUTH,gridx=0,gridy=0,fill=BOTH,weighty=1,insets=[5,5,5,5]", this.getSelectableElementView().getComponent());
        this.add("anchor=SOUTH,gridx=0,gridy=1,fill=HORIZONTAL,insets=[5,5,5,5]", this.buttonPanel.getPanel());
        this.buttonPanel.updateState(false);
    }

    @Override
    public void elementAdded(E element) {
        this.getSelectableElementView().elementInserted(element);
    }

    @Override
    public void elementDeleted(E element, int index) {
        this.getSelectableElementView().elementDeleted(element, index);
    }

    @Override
    public void elementUpdated(E element) {
        this.getSelectableElementView().elementUpdated(element);
    }

    @Override
    public void updateView() {
        this.getModel().clearCaches();
        this.getSelectableElementView().refresh();
    }

    protected final CrudModel<E, I> getModel() {
        return this.model;
    }

    public SelectableElementView<E, I> getSelectableElementView() {
        return this.selectableElementView;
    }

    public WindowStack getWindowStack() {
        return this.session;
    }

    @Override
    public E getSelectedElement() {
        return this.getSelectableElementView().getSelectedElement();
    }
}

