/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.ButtonSpecification;
import com.schneide.base.application.crud.CrudButtonPanel;
import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.CrudProcess;
import com.schneide.base.application.crud.gui.ElementManagementView;
import com.schneide.base.application.process.UserCancelledProcess;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.gui.dialog.button.NonvalidatingDialogButton;
import com.schneide.base.layout.StringGridBagLayout;
import com.schneide.base.threading.Executable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class GenericButtonPanel<E extends CrudElement<I>, I>
extends JPanel
implements CrudButtonPanel<E, I> {
    private static final long serialVersionUID = 2293968434247789974L;
    private final List<JButton> selectAwareButtons;
    private int buttonIndex;
    private ElementManagementView<E, I> view;
    private final SchneideSession<?> session;

    public GenericButtonPanel(SchneideSession<?> session, Iterable<ButtonSpecification<E, I>> buttons) {
        super((LayoutManager)new StringGridBagLayout());
        this.session = session;
        this.buttonIndex = 0;
        this.view = null;
        this.selectAwareButtons = new ArrayList<JButton>();
        this.buildUI(buttons);
    }

    protected void buildUI(Iterable<ButtonSpecification<E, I>> buttons) {
        for (ButtonSpecification<E, I> specification : buttons) {
            this.addButton(specification);
        }
    }

    @Override
    public void updateState(boolean hasSelection) {
        for (JButton button : this.selectAwareButtons) {
            button.setEnabled(hasSelection);
        }
    }

    @Override
    public void addButton(ButtonSpecification<E, I> specification) {
        if (!this.session.isAllowed(specification.getRightIdentifier())) {
            return;
        }
        NonvalidatingDialogButton button = new NonvalidatingDialogButton(specification.getDisplayInformation());
        button.addActionListener(new CrudButtonProcessStarter(specification.getButtonProcess()));
        button.setEnabled(specification.isInitiallyEnabled());
        this.add("anchor=SOUTH,gridx=" + this.buttonIndex + ",gridy=0,fill=HORIZONTAL,insets=[5,5,5,5]", (Component)button);
        ++this.buttonIndex;
        if (specification.isSelectionAware()) {
            this.selectAwareButtons.add((JButton)button);
            this.updateState(false);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public ElementManagementView<E, I> getView() {
        return this.view;
    }

    @Override
    public void setView(ElementManagementView<E, I> newView) {
        this.view = newView;
    }

    private class CrudButtonProcessStarter
    implements ActionListener {
        private final CrudProcess<E, I> process;

        public CrudButtonProcessStarter(CrudProcess<E, I> process) {
            this.process = process;
        }

        private CrudProcess<E, I> getProcess() {
            return this.process;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Executable runner = new Executable("CRUD process"){

                protected void execute() throws Exception {
                    try {
                        boolean hasToUpdate = CrudButtonProcessStarter.this.getProcess().startProcess(GenericButtonPanel.this.getView().getSelectedElement());
                        if (hasToUpdate) {
                            GenericButtonPanel.this.getView().updateView();
                        }
                    }
                    catch (UserCancelledProcess cancelException) {
                        this.getLogger().debug((Object)"User cancellation of CRUD process.");
                    }
                }
            };
            runner.startExecution();
        }
    }
}

