/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.gui.SelectableView;
import com.schneide.base.gui.data.bindings.TableColumnBinder;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.gui.data.bindings.TableDoubleClickListener;
import com.schneide.base.gui.data.value.ListValue;
import com.schneide.base.gui.swing.EDT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionListener;

public class BindedTableView<E extends CrudElement<I>, I>
extends JPanel
implements SelectableView<E, I> {
    private static final long serialVersionUID = -421155627158904632L;
    private JTable table;
    private final ListValue<E> listValue;
    private final List<TableColumnBinding> bindings;
    private TableDoubleClickListener tableDoubleClickListener;
    private final int sortColumn;

    public BindedTableView(ListValue<E> listValue, TableColumnBinding ... bindings) {
        this(listValue, -1, bindings);
    }

    public BindedTableView(ListValue<E> listValue, int sortColumn, TableColumnBinding ... bindings) {
        this(listValue, sortColumn, Arrays.asList(bindings));
    }

    public BindedTableView(ListValue<E> listValue, int sortColumn, List<TableColumnBinding> bindings) {
        super(new BorderLayout());
        this.listValue = listValue;
        this.sortColumn = sortColumn;
        this.bindings = bindings;
        this.buildUI();
    }

    private void buildUI() {
        this.table = new JTable();
        this.table.getSelectionModel().setSelectionMode(0);
        this.tableDoubleClickListener = new TableDoubleClickListener(this.bindings);
        this.table.addMouseListener((MouseListener)this.tableDoubleClickListener);
        TableColumnBinder tableColumnBinder = new TableColumnBinder();
        this.addColumnBindingsTo(tableColumnBinder);
        tableColumnBinder.bindTo(this.table, this.listValue);
        if (-1 != this.sortColumn) {
            this.table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(this.sortColumn, SortOrder.ASCENDING)));
        }
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void addColumnBindingsTo(TableColumnBinder<E> tableColumnBinder) {
        for (TableColumnBinding binding : this.bindings) {
            tableColumnBinder.addColumnBinding(binding);
        }
    }

    @Override
    public void addRowListener(TableDoubleClickListener.IRowDoubleClickListener l) {
        this.tableDoubleClickListener.addRowListener(l);
    }

    @Override
    public void removeRowListener(TableDoubleClickListener.IRowDoubleClickListener l) {
        this.tableDoubleClickListener.removeRowListener(l);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public E getElementAt(int rowIndex) {
        int index = this.table.getRowSorter().convertRowIndexToModel(rowIndex);
        return (E)((CrudElement)this.listValue.getElementAt(index));
    }

    public int getIndexOf(E element) {
        return this.table.getRowSorter().convertRowIndexToView(this.listValue.indexOf(element));
    }

    @Override
    public E getSelectedElement() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return this.getElementAt(this.getSelectedIndex());
    }

    public void clearSelection() {
        EDT.always();
        this.table.getSelectionModel().clearSelection();
    }

    @Override
    public void setSelectedElement(E element) throws NoSuchElementException {
        int index = this.getIndexOf(element);
        if (-1 == index) {
            throw new NoSuchElementException("Element not found for selection");
        }
        this.table.getSelectionModel().setSelectionInterval(index, index);
        Rectangle requiredView = this.table.getCellRect(index, 0, true);
        this.table.scrollRectToVisible(requiredView);
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.table.getSelectionModel().isSelectionEmpty();
    }

    public void makeSelectionVisible() {
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getSelectedRow(), 0, true));
    }
}

