/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.crud.gui;

import com.schneide.base.application.crud.ButtonPanelSpecification;
import com.schneide.base.application.crud.CrudElement;
import com.schneide.base.application.crud.gui.BindedTableView;
import com.schneide.base.application.crud.gui.ElementManagementView;
import com.schneide.base.application.crud.gui.GenericButtonPanel;
import com.schneide.base.application.crud.gui.SelectableView;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.gui.data.bindings.TableColumnBinding;
import com.schneide.base.gui.data.bindings.TableDoubleClickListener;
import com.schneide.base.gui.data.value.ListValue;
import com.schneide.base.gui.dialog.AbstractSchneideDialog;
import com.schneide.base.gui.model.WindowStack;
import com.schneide.base.i18n.I18NKey;
import com.schneide.base.i18n.model.I18NKeyed;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class BindedElementManagementDialog<E extends CrudElement<I>, I>
extends AbstractSchneideDialog<E>
implements ElementManagementView<E, I> {
    private final ListValue<E> listValue;
    private final SelectableView<E, I> selectableElementView;
    private final Iterable<ButtonPanelSpecification<E, I>> buttonPanelSpecifications;
    private final TableColumnBinding<E, ?>[] bindings;
    private final SchneideSession<?> session;

    public BindedElementManagementDialog(SchneideSession<?> session, WindowStack windowStack, I18NKey baseKey, ListValue<E> listValue, TableColumnBinding<E, ?>[] bindings, Iterable<ButtonPanelSpecification<E, I>> buttonSpecifications) {
        this(session, windowStack, baseKey, listValue, -1, bindings, buttonSpecifications);
    }

    public BindedElementManagementDialog(SchneideSession<?> session, WindowStack windowStack, I18NKey baseKey, ListValue<E> listValue, int sort, TableColumnBinding<E, ?>[] bindings, Iterable<ButtonPanelSpecification<E, I>> buttonSpecifications) {
        super(windowStack, (I18NKeyed)baseKey);
        this.session = session;
        this.listValue = listValue;
        this.bindings = bindings;
        this.buttonPanelSpecifications = buttonSpecifications;
        this.selectableElementView = new BindedTableView(this.listValue, sort, this.bindings);
    }

    public final void addRowListener(TableDoubleClickListener.IRowDoubleClickListener l) {
        this.selectableElementView.addRowListener(l);
    }

    public final void removeRowListener(TableDoubleClickListener.IRowDoubleClickListener l) {
        this.selectableElementView.removeRowListener(l);
    }

    protected void buildUI() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel buttonsPanel = this.createButtonsPanel();
        content.add(this.selectableElementView.getComponent(), "Center");
        content.add((Component)buttonsPanel, "South");
        this.setContent(content);
        this.addButton().closeButton();
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("wrap 1"));
        for (ButtonPanelSpecification<E, I> panelSpecification : this.buttonPanelSpecifications) {
            GenericButtonPanel<E, I> buttonPanel = new GenericButtonPanel<E, I>(this.session, panelSpecification.getButtonSpecifications());
            buttonPanel.setView(this);
            this.selectableElementView.addListSelectionListener(e -> buttonPanel.updateState(!this.selectableElementView.isSelectionEmpty()));
            buttonsPanel.add(buttonPanel);
            buttonPanel.updateState(false);
        }
        return buttonsPanel;
    }

    protected void addToTopView(JComponent component) {
        this.getContent().add((Component)component, "North");
    }

    @Override
    public void elementAdded(E element) {
    }

    @Override
    public void elementDeleted(E element, int index) {
    }

    @Override
    public void elementUpdated(E element) {
    }

    protected void setPreferredViewSize(Dimension size) {
        this.selectableElementView.getComponent().setPreferredSize(size);
    }

    protected Optional<E> giveAnswer() {
        return Optional.ofNullable(this.getSelectedElement());
    }

    @Override
    public E getSelectedElement() {
        return this.selectableElementView.getSelectedElement();
    }

    public void setSelectedElement(E element) throws NoSuchElementException {
        this.selectableElementView.setSelectedElement(element);
    }

    @Override
    public void updateView() {
    }

    protected SchneideSession<?> getSession() {
        return this.session;
    }
}

