/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.configuration.implementation;

import com.schneide.base.application.configuration.SystemConfiguration;
import com.schneide.base.application.configuration.implementation.ConfigurationFallbackHandler;
import com.schneide.base.configuration.SecureConfiguration;
import com.schneide.base.configuration.domain.ConfigurationLocationOf;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.properties.Configuration;
import java.io.File;

public class FileBasedSystemConfiguration
extends ConfigurationFallbackHandler
implements SystemConfiguration {
    public FileBasedSystemConfiguration(VirtualFile propertiesFile) {
        super(new SecureConfiguration(propertiesFile, "Schneide Systemeinstellungen (Kunden-Layer)"), new Configuration(new VirtualFile[]{FileLocator.getFile((VirtualFile)ConfigurationLocationOf.internals(), (String)"system/system.settings")}));
    }

    @Override
    public File getSplashScreenConfigurationFile() {
        return this.getFileProperty("file.configuration.splashScreen", "internals/presentation/splashscreen.settings");
    }

    @Override
    public String getLookAndFeelClassname() {
        return this.getStringProperty("gui.lookAndFeel.classname", "javax.swing.plaf.metal.MetalLookAndFeel");
    }

    @Override
    public String getLookAndFeelColorThemeClassname() {
        return this.getStringProperty("gui.lookAndFeel.colorTheme.classname", "");
    }

    @Override
    public File getApplicationConfigurationFile() {
        return this.getFileProperty("file.configuration.application", "settings/application/application.properties");
    }

    @Override
    public File getInteractionConfigurationFile() {
        return this.getFileProperty("file.configuration.menumanager", "internals/interaction/interaction.settings");
    }

    @Override
    public File getUserManagerConfigurationFile() {
        return this.getFileProperty("file.configuration.usermanager", "internals/usermanagement/usermanager.settings");
    }

    @Override
    public File getIconFile() {
        return this.getFileProperty("file.icon", "resources/images/icons/icon16.png");
    }

    @Override
    public File getTeamCreditFile() {
        return this.getFileProperty("file.configuration.teamCredits", "internals/presentation/teamcredits.settings");
    }

    @Override
    public File getI18NConfigurationFile() {
        return this.getFileProperty("file.configuration.i18n", "settings/system/i18n.config");
    }

    @Override
    public File getAutoexecutionConfigurationFile() {
        return this.getFileProperty("file.configuration.autoexecution", "settings/system/execution/autoexec.config");
    }

    @Override
    public File getBootExecutionConfigurationFile() {
        return this.getFileProperty("file.configuration.bootexecution", "settings/system/execution/bootexec.config");
    }

    @Override
    public File getCronexecutionConfigurationFile() {
        return this.getFileProperty("file.configuration.cronexecution", "settings/system/execution/cronexec.config");
    }

    @Override
    public File getModuleConfigurationFile() {
        return this.getFileProperty("file.configuration.modules", "settings/system/module.config");
    }

    @Override
    public boolean getSelectCronProcessesSchedulingState() {
        return this.getBooleanProperty("processes.cron.scheduleSelection.enabled", false);
    }

    @Override
    public boolean isDeveloperModeEnabled() {
        return this.getBooleanProperty("developer.mode.enabled", false);
    }

    @Override
    public boolean isSplashscreenEnabled() {
        return this.getBooleanProperty("splashscreen.enabled", true);
    }

    @Override
    public File getNativeLibraryConfigurationFile() {
        return this.getFileProperty("file.configuration.nativelibrary.paths", "internals/system/nativelibs.settings");
    }

    @Override
    public boolean isTouchscreenEnabled() {
        return this.getBooleanProperty("touchscreen.enabled", false);
    }

    @Override
    public boolean isNewsLoggingForced() {
        return this.getBooleanProperty("eventbus.logging.forced", false);
    }

    @Override
    public boolean isNewsLoggingEnabled() {
        return this.getBooleanProperty("eventbus.logging.enabled", true);
    }

    @Override
    public boolean displayEventbusSubscribers() {
        return this.getBooleanProperty("eventbus.display.subscribers[yes/no]", false);
    }
}

