/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application.configuration.implementation;

import com.schneide.base.configuration.ParsedProperties;
import com.schneide.base.configuration.SecureConfiguration;
import com.schneide.base.io.file.FileLocator;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import java.io.File;

public abstract class ConfigurationFallbackHandler
extends LoggedObject {
    private final SecureConfiguration userConfiguration;
    private final Configuration defaultConfiguration;

    protected ConfigurationFallbackHandler(SecureConfiguration userConfiguration, Configuration defaultConfiguration) {
        this.userConfiguration = userConfiguration;
        this.defaultConfiguration = defaultConfiguration;
    }

    protected File getFileProperty(String key, String fallbackPath) {
        if (this.getUserConfiguration().containsProperty(key)) {
            return this.getUserConfiguration().getFileProperty(key, fallbackPath);
        }
        if (this.getDefaultConfiguration().hasProperty(key)) {
            return FileLocator.getFile((String)this.getDefaultConfiguration().getPropertyValue(key));
        }
        return FileLocator.getFile((String)fallbackPath);
    }

    protected Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    protected SecureConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    protected String getStringProperty(String key, String fallbackText) {
        if (this.getUserConfiguration().containsProperty(key)) {
            return this.getUserConfiguration().getStringProperty(key, fallbackText);
        }
        if (this.getDefaultConfiguration().hasProperty(key)) {
            return this.getDefaultConfiguration().getPropertyValue(key);
        }
        return fallbackText;
    }

    protected boolean getBooleanProperty(String key, boolean fallbackState) {
        if (this.getUserConfiguration().containsProperty(key)) {
            return this.getUserConfiguration().getBooleanProperty(key, fallbackState);
        }
        if (this.getDefaultConfiguration().hasProperty(key)) {
            return ParsedProperties.PARSER_BOOLEAN.parse(key, this.getDefaultConfiguration().getPropertyValue(key));
        }
        return fallbackState;
    }
}

