/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.base.application;

import com.schneide.base.application.ApplicationEngine;
import com.schneide.base.application.SchneideApplication;
import com.schneide.base.application.configuration.SystemConfiguration;
import com.schneide.base.application.interaction.ConfiguredActionManager;
import com.schneide.base.application.interaction.MenuManager;
import com.schneide.base.application.interaction.SwingMenuManager;
import com.schneide.base.application.interaction.configuration.InteractionConfiguration;
import com.schneide.base.application.interaction.model.ActionManager;
import com.schneide.base.application.interaction.model.ActivationContextProvider;
import com.schneide.base.application.interaction.model.ProcessContextHandler;
import com.schneide.base.application.interaction.model.implementation.GenericProcessContextHandler;
import com.schneide.base.application.session.SchneideSession;
import com.schneide.base.application.session.SessionHandler;
import com.schneide.base.application.usermanagement.model.SchneideUser;
import com.schneide.base.application.usermanagement.model.UserDataHolder;
import com.schneide.base.application.usermanagement.model.UserManager;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.io.virtual.local.LocalVirtualFile;
import com.schneide.base.io.virtual.wrapper.DeveloperOverdrive;
import com.schneide.base.logging.LoggedObject;

public abstract class AbstractApplicationEngine<S extends SchneideSession<U>, U extends SchneideUser>
extends LoggedObject
implements ApplicationEngine<S, U> {
    private final SchneideApplication application;
    private final ActionManager<S, U> actionManager;
    private final SessionHandler<S, U> sessionHandler;
    private final MenuManager<S, U> menuManager;
    private final ProcessContextHandler processContextHandler;
    private final UserDataHolder<U> userDataHolder;
    private UserManager<U> userManager;

    public AbstractApplicationEngine(SchneideApplication application, SystemConfiguration systemConfiguration, SessionHandler<S, U> sessionHandler) {
        this.application = application;
        this.sessionHandler = sessionHandler;
        InteractionConfiguration interactionConfiguration = new InteractionConfiguration((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(systemConfiguration.getInteractionConfigurationFile())));
        this.processContextHandler = new GenericProcessContextHandler(new Object[0]);
        this.actionManager = new ConfiguredActionManager(interactionConfiguration, this.processContextHandler);
        this.menuManager = new SwingMenuManager<S, U>(this.actionManager, interactionConfiguration);
        this.userManager = null;
        this.userDataHolder = this.buildUserDataHolder((VirtualFile)DeveloperOverdrive.of((VirtualFile)new LocalVirtualFile(systemConfiguration.getUserManagerConfigurationFile())), systemConfiguration);
    }

    public void start() {
        this.userManager = this.buildUserManager(this.userDataHolder);
    }

    protected abstract UserDataHolder<U> buildUserDataHolder(VirtualFile var1, SystemConfiguration var2);

    protected abstract UserManager<U> buildUserManager(UserDataHolder<U> var1);

    @Override
    public ActionManager<S, U> getActionManager() {
        return this.actionManager;
    }

    @Override
    public ProcessContextHandler getProcessContextHandler() {
        return this.processContextHandler;
    }

    @Override
    public ActivationContextProvider getProcessContextProvider() {
        return this.getProcessContextHandler();
    }

    @Override
    public UserManager<U> getUserManager() {
        return this.userManager;
    }

    @Override
    public MenuManager<S, U> getMenuManager() {
        return this.menuManager;
    }

    @Override
    public SchneideApplication getApplication() {
        return this.application;
    }

    @Override
    public final SessionHandler<S, U> getSessionHandler() {
        return this.sessionHandler;
    }

    @Override
    public Thread runProcess(String actionReference, S session) {
        return this.getActionManager().performAction(actionReference, session);
    }

    @Override
    public UserDataHolder<U> getUserDataHolder() {
        return this.userDataHolder;
    }

    @Override
    public void stop() {
        this.getUserDataHolder().destroy();
    }
}

