/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json.domain;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import com.schneide.werp.module.datenspeicherung.json.JsonBasedPersistence;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class JsonPersistence
extends JsonBasedPersistence {
    protected JsonObject jsonify(Produktionskoordinate koordinate) {
        JsonObject result = new JsonObject();
        result.addProperty("Kontext", koordinate.nummer().alsText());
        result.add("Position", (JsonElement)this.numberArray(koordinate.alsZahlenfolge()));
        return result;
    }

    protected Optional<Produktionskoordinate> dejsonifyProduktionskoordinate(Map<String, Object> json) {
        String projekt = this.stringFrom(json, "Kontext");
        List<Integer> positionen = this.integersFrom(json, "Position");
        return Optional.of(new Produktionskoordinate(new Produktionsnummer(projekt), positionen));
    }

    protected JsonObject jsonify(ArbeitsauftragIdentifikation identifikation) {
        JsonObject result = new JsonObject();
        result.addProperty("Produktionsnummer", identifikation.projekt().alsText());
        result.addProperty("Index", (Number)identifikation.index());
        return result;
    }

    protected Optional<ArbeitsauftragIdentifikation> dejsonifyArbeitsauftragIdentifikation(Map<String, Object> json) {
        String projekt = this.stringFrom(json, "Produktionsnummer");
        int index = this.integerFrom(json, "Index");
        return Optional.of(new ArbeitsauftragIdentifikation(new Produktionsnummer(projekt), index));
    }
}

