/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.datenspeicherung.json.bereiche;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.artikel.ArtikelRepository;
import com.schneide.werp.domain.artikel.Artikelnummer;
import com.schneide.werp.domain.artikel.Artikelreferenz;
import com.schneide.werp.domain.artikel.Artikelrevision;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.Arbeitsauftrag;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.ProduktionsartikelRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import com.schneide.werp.domain.erf\u00fcllung.schritt.ArbeitsschrittRepository;
import com.schneide.werp.domain.projekt.Projekt;
import com.schneide.werp.domain.projekt.Projektnummer;
import com.schneide.werp.domain.projekt.Projektst\u00fccklisteneintrag;
import com.schneide.werp.module.datenspeicherung.json.domain.JsonPersistence;
import com.schneide.werp.periphery.datenspeicherung.bereiche.ArbeitsauftragDatenspeicherung;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonBasedArbeitsauftragPersistence
extends JsonPersistence
implements ArbeitsauftragDatenspeicherung {
    public void speichere(Arbeitsauftrag auftrag, VirtualFile inDatei) throws IOException {
        JsonObject result = new JsonObject();
        result.add("Identifikation", (JsonElement)this.jsonify(auftrag.identifikation()));
        result.add("Listenkoordinate", (JsonElement)this.jsonify(auftrag.listenkoordinate()));
        result.add("Produktionsartikel", (JsonElement)this.jsonify(auftrag.f\u00fcrArtikel().koordinate()));
        result.addProperty("Anzahl", (Number)auftrag.anzahl());
        result.addProperty("Arbeitsschritt", auftrag.t\u00e4tigkeit().nummer());
        result.add("Vorarbeiten", (JsonElement)this.objectArray(auftrag.vorarbeiten(), aa -> this.jsonify((ArbeitsauftragIdentifikation)aa)));
        result.add("Nacharbeiten", (JsonElement)this.objectArray(auftrag.nacharbeiten(), aa -> this.jsonify((ArbeitsauftragIdentifikation)aa)));
        result.addProperty("Kommentar", auftrag.kommentar());
        this.schreibe((JsonElement)result, inDatei);
    }

    public Optional<Arbeitsauftrag> ladeAus(VirtualFile datei, ArbeitsschrittRepository alleArbeitsschritte, ArbeitsauftragRepository alleArbeitsauftr\u00e4ge, ProduktionsartikelRepository alleProduktionsartikel) throws IOException {
        try (JsonReader reader = new JsonReader(datei.getReader());){
            Map data = (Map)this.json().fromJson(reader, HashMap.class);
            Optional<ArbeitsauftragIdentifikation> identifikation = this.dejsonifyArbeitsauftragIdentifikation(this.objectFrom(data, "Identifikation"));
            if (identifikation.isEmpty()) {
                this.getLogger().error((Object)"Kann eine ArbeitsauftragIdentifikation nicht parsen.");
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            Optional<Produktionskoordinate> koordinate = this.dejsonifyProduktionskoordinate(this.objectFrom(data, "Listenkoordinate"));
            if (koordinate.isEmpty()) {
                this.getLogger().error((Object)"Kann eine Produktionskoordinate nicht parsen.");
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            Optional<Produktionskoordinate> produktionsartikelkoordinate = this.dejsonifyProduktionskoordinate(this.objectFrom(data, "Produktionsartikel"));
            if (koordinate.isEmpty()) {
                this.getLogger().error((Object)"Kann eine Produktionskoordinate nicht parsen.");
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            Optional maybeArtikel = alleProduktionsartikel.f\u00fcr(produktionsartikelkoordinate.get());
            if (maybeArtikel.isEmpty()) {
                this.getLogger().error((Object)("Kann einen Produktionsartikel nicht dereferenzieren: " + String.valueOf(produktionsartikelkoordinate.get())));
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            String arbeitsschrittIdentifier = this.stringFrom(data, "Arbeitsschritt");
            Optional maybeArbeitsschritt = alleArbeitsschritte.f\u00fcr(arbeitsschrittIdentifier);
            if (maybeArbeitsschritt.isEmpty()) {
                this.getLogger().error((Object)("Kann einen Arbeitsschritt nicht dereferenzieren: " + arbeitsschrittIdentifier));
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            Optional<List<ArbeitsauftragIdentifikation>> vorarbeiten = this.ladeReferenzierteAuftr\u00e4geAus(this.objectListFrom(data, "Vorarbeiten"), alleArbeitsauftr\u00e4ge);
            if (vorarbeiten.isEmpty()) {
                this.getLogger().error((Object)("Konnte die Vorarbeiten zu " + String.valueOf(identifikation.get()) + " nicht dereferenzieren."));
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            Optional<List<ArbeitsauftragIdentifikation>> nacharbeiten = this.ladeReferenzierteAuftr\u00e4geAus(this.objectListFrom(data, "Nacharbeiten"), alleArbeitsauftr\u00e4ge);
            if (nacharbeiten.isEmpty()) {
                this.getLogger().error((Object)("Konnte die Nacharbeiten zu " + String.valueOf(identifikation.get()) + " nicht dereferenzieren."));
                Optional<Arbeitsauftrag> optional = Optional.empty();
                return optional;
            }
            int anzahl = this.integerFrom(data, "Anzahl");
            String kommentar = this.stringFrom(data, "Kommentar");
            Arbeitsauftrag result = new Arbeitsauftrag(identifikation.get(), (Produktionsartikel)maybeArtikel.get(), koordinate.get(), anzahl, (Arbeitsschritt)maybeArbeitsschritt.get(), kommentar);
            vorarbeiten.get().forEach(arg_0 -> ((Arbeitsauftrag)result).h\u00e4ngtAbVon(arg_0));
            nacharbeiten.get().forEach(arg_0 -> ((Arbeitsauftrag)result).vorarbeitVon(arg_0));
            Optional<Arbeitsauftrag> optional = Optional.of(result);
            return optional;
        }
    }

    private Optional<List<ArbeitsauftragIdentifikation>> ladeReferenzierteAuftr\u00e4geAus(List<Map<String, Object>> alleReferenzen, ArbeitsauftragRepository alleArbeitsauftr\u00e4ge) {
        ArrayList<ArbeitsauftragIdentifikation> result = new ArrayList<ArbeitsauftragIdentifikation>();
        for (Map<String, Object> each : alleReferenzen) {
            Optional<ArbeitsauftragIdentifikation> maybeIdentifier = this.dejsonifyArbeitsauftragIdentifikation(each);
            if (maybeIdentifier.isEmpty()) {
                this.getLogger().error((Object)"Kann eine ArbeitsauftragIdentifikation nicht parsen.");
                return Optional.empty();
            }
            ArbeitsauftragIdentifikation identifier = maybeIdentifier.get();
            if (!alleArbeitsauftr\u00e4ge.verwaltet(identifier)) {
                this.getLogger().error((Object)("Kann einen Arbeitsauftrag nicht dereferenzieren: " + String.valueOf(maybeIdentifier.get())));
                return Optional.empty();
            }
            result.add(identifier);
        }
        return Optional.of(result);
    }

    public Optional<Projekt> ladeAus(VirtualFile datei, ArtikelRepository artikel) throws IOException {
        this.getLogger().debug((Object)("Lade Projekt aus " + String.valueOf(datei)));
        try (JsonReader reader = new JsonReader(datei.getReader());){
            Map data = (Map)this.json().fromJson(reader, HashMap.class);
            String projektnummer = this.stringFrom(data, "Projektnummer");
            String kunde = this.stringFrom(data, "Kunde");
            String beschreibung = this.stringFrom(data, "Beschreibung");
            List<String> kommentare = this.stringsFrom(data, "Kommentare");
            Iterable<Projektst\u00fccklisteneintrag> projektst\u00fcckliste = this.st\u00fccklisteAus(this.objectListFrom(data, "St\u00fcckliste"), artikel);
            Projekt result = new Projekt(new Projektnummer(projektnummer), kunde, beschreibung, kommentare, projektst\u00fcckliste);
            Optional<Projekt> optional = Optional.of(result);
            return optional;
        }
    }

    private Iterable<Projektst\u00fccklisteneintrag> st\u00fccklisteAus(List<Map<String, Object>> eintr\u00e4ge, ArtikelRepository artikel) {
        ArrayList<Projektst\u00fccklisteneintrag> result = new ArrayList<Projektst\u00fccklisteneintrag>();
        eintr\u00e4ge.forEach(each -> {
            Artikelreferenz referenz = new Artikelreferenz(new Artikelnummer(this.stringFrom((Map<String, Object>)each, "Artikelnummer")), new Artikelrevision(this.integerFrom((Map<String, Object>)each, "Revision")));
            Optional maybeArtikel = artikel.f\u00fcrReferenz(referenz);
            if (maybeArtikel.isEmpty()) {
                return;
            }
            Projektst\u00fccklisteneintrag eintrag = new Projektst\u00fccklisteneintrag(this.integerFrom((Map<String, Object>)each, "Position"), this.integerFrom((Map<String, Object>)each, "Anzahl"), (Artikel)maybeArtikel.get());
            result.add(eintrag);
        });
        return result;
    }
}

