/*----- PROTECTED REGION ID(TimeDevice.cpp) ENABLED START -----*/
static const char *RcsId = "$Id:  $";
//=============================================================================
//
// file :        TimeDevice.cpp
//
// description : C++ source for the TimeDevice and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               TimeDevice are implemented in this file.
//
// project :     TimeProvider.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source:  $
// $Log:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <TimeDevice.h>
#include <TimeDeviceClass.h>

#include "TimeProvider.h"

/*----- PROTECTED REGION END -----*/


/**
 *	TimeDevice class description:
 *	
 */

//================================================================
//
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//----------------------------------------------------------------
//  State         |  Inherited (no method)
//  Status        |  Inherited (no method)
//================================================================

//	Attribute managed is:
//	CurrentTime:	




namespace TimeDevice_ns
{
	/*----- PROTECTED REGION ID(TimeDevice::namespace_starting) ENABLED START -----*/

	//	static initializations

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::namespace_starting



//--------------------------------------------------------
/**
 *	Method      : TimeDevice::TimeDevice()
 *	Description : Constructors for a Tango device
 *	              implementing the class TimeDevice
 */
//--------------------------------------------------------
TimeDevice::TimeDevice(Tango::DeviceClass *cl, string &s)
 	: Tango::Device_4Impl(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(TimeDevice::constructor_1) ENABLED START -----*/

	init_device();

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::constructor_1
}
//--------------------------------------------------------
TimeDevice::TimeDevice(Tango::DeviceClass *cl, const char *s)
 	: Tango::Device_4Impl(cl, s)
{
	/*----- PROTECTED REGION ID(TimeDevice::constructor_2) ENABLED START -----*/

	init_device();

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::constructor_2
}
//--------------------------------------------------------
TimeDevice::TimeDevice(Tango::DeviceClass *cl, const char *s, const char *d)
 	: Tango::Device_4Impl(cl, s, d)
{
	/*----- PROTECTED REGION ID(TimeDevice::constructor_3) ENABLED START -----*/

	init_device();

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::constructor_3
}


//--------------------------------------------------------
/**
 *	Method      : TimeDevice::delete_device()()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void TimeDevice::delete_device()
{
	DEBUG_STREAM << "TimeDevice::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(TimeDevice::delete_device) ENABLED START -----*/

	//	Delete device allocated objects

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::delete_device
	
	
}


//--------------------------------------------------------
/**
 *	Method      : TimeDevice::init_device()
 *	Description : //	will be called at device initialization.
 */
//--------------------------------------------------------
void TimeDevice::init_device()
{
	DEBUG_STREAM << "TimeDevice::init_device() create device " << device_name << endl;
	

	
	/*----- PROTECTED REGION ID(TimeDevice::init_device) ENABLED START -----*/

	//	Initialize device

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::init_device
}




//--------------------------------------------------------
/**
 *	Method      : TimeDevice::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void TimeDevice::always_executed_hook()
{
	INFO_STREAM << "TimeDevice::always_executed_hook()  " << device_name << endl;
	
	/*----- PROTECTED REGION ID(TimeDevice::always_executed_hook) ENABLED START -----*/

	//	code always executed before all requests

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::always_executed_hook
}




//--------------------------------------------------------
/**
 *	Method      : TimeDevice::read_attr_hardware()
 *	Description : Hardware acquisition for attributes.
 */
//--------------------------------------------------------
void TimeDevice::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "TimeDevice::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(TimeDevice::read_attr_hardware) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::read_attr_hardware

}


//--------------------------------------------------------
/**
 *	Read CurrentTime attribute
 *	Description: 
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Scalar 
 */
//--------------------------------------------------------
void TimeDevice::read_CurrentTime(Tango::Attribute &attr)
{
	DEBUG_STREAM << "TimeDevice::read_CurrentTime(Tango::Attribute &attr) entering... " << endl;
	/*----- PROTECTED REGION ID(TimeDevice::read_CurrentTime) ENABLED START -----*/
    
    attr_CurrentTime_read = new Tango::DevString;
    TimeProvider timeProvider;
    *attr_CurrentTime_read = Tango::string_dup(timeProvider.now().c_str());
    //	Set the attribute value
    attr.set_value(attr_CurrentTime_read, 1, 0, true);

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::read_CurrentTime
}



//--------------------------------------------------------
/**
 *	Method      : TimeDevice::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any at server startup
 *	              for specified device.
 */
//--------------------------------------------------------
void TimeDevice::add_dynamic_attributes()
{
	
	/*----- PROTECTED REGION ID(TimeDevice::add_dynamic_attributes) ENABLED START -----*/

	//	Add your own code to create and add dynamic attributes if any

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::add_dynamic_attributes()
}



//========================================================
//	Command execution methods
//========================================================


	/*----- PROTECTED REGION ID(TimeDevice::namespace_ending) ENABLED START -----*/

	//	Additional Methods

	/*----- PROTECTED REGION END -----*/	//	TimeDevice::namespace_ending
} //	namespace
