
#define BOOST_ENABLE_ASSERT_HANDLER
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/ui/qt/TestRunner.h>
#include <string>
#include <dlfcn.h>
#include <iostream>
#include <boost/filesystem/convenience.hpp>
#include <boost/filesystem/path.hpp>

using namespace boost::filesystem;
using namespace std;

void loadPlugins(const std::string& rootPath)
{
	directory_iterator end_itr;
	for (directory_iterator itr(rootPath); itr != end_itr; ++itr) {
		if (is_directory(*itr)) {
			string leaf = (*itr).leaf();
			if (leaf[0] != '.') {
				loadPlugins((*itr).string());
			}
			continue;
		}
		if (extension(*itr) == ".so") {
			string fileName = (*itr).string();
			if (fileName.find("_tests.so") != string::npos) {
				void * handle = dlopen (fileName.c_str(), RTLD_NOW | RTLD_GLOBAL);
				cout <<"Opening : " << fileName.c_str() << endl;
				if (!handle) {
					cout <<"Error: " << dlerror() << endl;
					exit (1);
				}
			}
		}
	}
}

namespace boost
{
	void assertion_failed(char const * expr, char const * function, char const * file, long line)
	{
		cerr  << "Boost Assertion : " << expr << endl
				<< "Function        : " << function << endl
				<< "Location        : " << file << ", " << line << endl;
	}

} // namespace boost

int main ( int argc, char ** argv )
{
	string rootPath = "./";

	if (argc > 1) {
		rootPath = static_cast<const char*>(argv[1]);
	}
	cout << "Loading all test libs under " << rootPath << endl;
	string runArg = std::string ( "All Tests" );

   // get registry
	CppUnit::TestFactoryRegistry & registry =
			CppUnit::TestFactoryRegistry::getRegistry();
   
	loadPlugins(rootPath);
   // Create the event manager and test controller
	CppUnit::TestResult controller;

   // Add a listener that colllects test result
	CppUnit::TestResultCollector result;
	controller.addListener ( &result );
	CppUnit::TextUi::TestRunner *runner = new CppUnit::TextUi::TestRunner;
	std::ofstream xmlout ( "testresultout.xml" );
	CppUnit::XmlOutputter xmlOutputter ( &result, xmlout );
	CppUnit::TextOutputter consoleOutputter ( &result, std::cout );

	runner->addTest ( registry.makeTest() );
	runner->run ( controller, runArg.c_str() );
	xmlOutputter.write();
	consoleOutputter.write();
	return result.wasSuccessful() ? 0 : 1;
}
