
//#include <qapplication.h>
#define BOOST_ENABLE_ASSERT_HANDLER
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestResultCollector.h>
#include <cppunit/XmlOutputter.h>
#include <cppunit/TextOutputter.h>
#include <cppunit/ui/text/TestRunner.h>
#include <string>
using namespace std;


int main ( int argc, char ** argv )
{
   // get registry
	CppUnit::TestFactoryRegistry & registry =
			CppUnit::TestFactoryRegistry::getRegistry();
   
   // Create the event manager and test controller
	CppUnit::TestResult controller;

   // Add a listener that colllects test result
	CppUnit::TestResultCollector result;
	controller.addListener ( &result );
	CppUnit::TextUi::TestRunner *runner = new CppUnit::TextUi::TestRunner;
	std::ofstream xmlout ( "testresultout.xml" );
	CppUnit::XmlOutputter xmlOutputter ( &result, xmlout );
	CppUnit::TextOutputter consoleOutputter ( &result, std::cout );

	runner->addTest ( registry.makeTest() );
	runner->run ( controller, "" );
	xmlOutputter.write();
	consoleOutputter.write();
	return result.wasSuccessful() ? 0 : 1;
}
