/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.GroupExpression;

public class InGroupPredicate
extends GroupExpression
implements Predicate {
    public InGroupPredicate() {
    }

    public InGroupPredicate(String string) {
        super(string);
    }

    @Override
    public Object get(Tuple tuple) {
        return this.getBoolean(tuple) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getBoolean(Tuple tuple) {
        if (!(tuple instanceof VisualItem)) {
            return false;
        }
        String string = this.getGroup(tuple);
        if (string == null) {
            return false;
        }
        VisualItem visualItem = (VisualItem)tuple;
        return visualItem.getVisualization().isInGroup(visualItem, string);
    }

    @Override
    public String getName() {
        return "INGROUP";
    }

    @Override
    public Class getType(Schema schema) {
        return Boolean.TYPE;
    }
}

