/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import java.util.logging.Logger;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Function;
import prefuse.data.expression.ObjectLiteral;

public abstract class GroupExpression
extends AbstractExpression
implements Function {
    private static final Logger s_logger = Logger.getLogger(GroupExpression.class.getName());
    protected Expression m_group;

    protected GroupExpression() {
        this.m_group = null;
    }

    protected GroupExpression(String string) {
        this.m_group = new ObjectLiteral(string);
    }

    protected String getGroup(Tuple tuple) {
        String string = (String)this.m_group.get(tuple);
        if (string == null) {
            s_logger.warning("Null group lookup");
        }
        return string;
    }

    @Override
    public void addParameter(Expression expression) {
        if (this.m_group != null) {
            throw new IllegalStateException("This function takes only 1 parameter.");
        }
        this.m_group = expression;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    public String toString() {
        return this.getName() + "(" + this.m_group + ")";
    }
}

