/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.InputEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UILib {
    private UILib() {
    }

    public static boolean isButtonPressed(InputEvent inputEvent, int n) {
        return (inputEvent.getModifiers() & n) == n;
    }

    public static final void setPlatformLookAndFeel() {
        try {
            String string = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Box getBox(Component[] componentArray, boolean bl, int n, int n2) {
        return UILib.getBox(componentArray, bl, n, n, n2);
    }

    public static Box getBox(Component[] componentArray, boolean bl, int n, int n2, int n3) {
        Box box = new Box(bl ? 0 : 1);
        UILib.addStrut((JComponent)box, bl, n);
        for (int i = 0; i < componentArray.length; ++i) {
            if (i > 0) {
                UILib.addStrut((JComponent)box, bl, n3);
                UILib.addGlue((JComponent)box, bl);
            }
            box.add(componentArray[i]);
        }
        UILib.addStrut((JComponent)box, bl, n2);
        return box;
    }

    public static void addStrut(JComponent jComponent, boolean bl, int n) {
        if (n < 1) {
            return;
        }
        jComponent.add(bl ? Box.createHorizontalStrut(n) : Box.createVerticalStrut(n));
    }

    public static void addGlue(JComponent jComponent, boolean bl) {
        jComponent.add(bl ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    public static void addStrut(JComponent jComponent, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        jComponent.add(UILib.getAxis(jComponent, n) == 0 ? Box.createHorizontalStrut(n2) : Box.createVerticalStrut(n2));
    }

    public static void addGlue(JComponent jComponent, int n) {
        jComponent.add(UILib.getAxis(jComponent, n) == 0 ? Box.createHorizontalGlue() : Box.createVerticalGlue());
    }

    public static int getAxis(JComponent jComponent, int n) {
        ComponentOrientation componentOrientation = jComponent.getComponentOrientation();
        switch (n) {
            case 2: {
                return componentOrientation.isHorizontal() ? 0 : 1;
            }
            case 3: {
                return componentOrientation.isHorizontal() ? 1 : 0;
            }
        }
        return n;
    }

    public static void setColor(Component component, Color color, Color color2) {
        component.setBackground(color);
        component.setForeground(color2);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                UILib.setColor(container.getComponent(i), color, color2);
            }
        }
    }

    public static void setFont(Component component, Font font) {
        component.setFont(font);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                UILib.setFont(container.getComponent(i), font);
            }
        }
    }
}

