/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LEFTRIGHT_TOPBOTTOM = 0;
    public static final int RIGHTLEFT_BOTTOMTOP = 1;
    public static final int PREFERRED_BREADTH = 16;
    public static final int PREFERRED_LENGTH = 300;
    protected static final int ARROW_SZ = 16;
    protected static final int ARROW_WIDTH = 8;
    protected static final int ARROW_HEIGHT = 4;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int direction;
    protected boolean empty;
    protected int increment = 1;
    protected int minExtent = 0;
    protected ArrayList listeners = new ArrayList();
    protected ChangeEvent changeEvent = null;
    protected ChangeListener lstnr;
    protected Color thumbColor = new Color(150, 180, 220);
    static final int PICK_NONE = 0;
    static final int PICK_LEFT_OR_TOP = 1;
    static final int PICK_THUMB = 2;
    static final int PICK_RIGHT_OR_BOTTOM = 3;
    int pick;
    int pickOffsetLow;
    int pickOffsetHigh;
    int mouse;

    public JRangeSlider(int n, int n2, int n3, int n4, int n5) {
        this(new DefaultBoundedRangeModel(n3, n4 - n3, n, n2), n5, 0);
    }

    public JRangeSlider(int n, int n2, int n3, int n4, int n5, int n6) {
        this(new DefaultBoundedRangeModel(n3, n4 - n3, n, n2), n5, n6);
    }

    public JRangeSlider(BoundedRangeModel boundedRangeModel, int n, int n2) {
        super.setFocusable(true);
        this.model = boundedRangeModel;
        this.orientation = n;
        this.direction = n2;
        this.setForeground(Color.LIGHT_GRAY);
        this.lstnr = this.createListener();
        boundedRangeModel.addChangeListener(this.lstnr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected ChangeListener createListener() {
        return new RangeSliderChangeListener();
    }

    public int getLowValue() {
        return this.model.getValue();
    }

    public void setLowValue(int n) {
        int n2 = this.model.getValue() - n + this.model.getExtent();
        this.model.setRangeProperties(n, n2, this.model.getMinimum(), this.model.getMaximum(), false);
        this.model.setValue(n);
    }

    public int getHighValue() {
        return this.model.getValue() + this.model.getExtent();
    }

    public void setHighValue(int n) {
        this.model.setExtent(n - this.model.getValue());
    }

    public void setRange(int n, int n2) {
        this.model.setRangeProperties(n, n2 - n, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int n) {
        this.model.setMinimum(n);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int n) {
        this.model.setMaximum(n);
    }

    public void setMinExtent(int n) {
        this.minExtent = n;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
        this.repaint();
    }

    public Color getThumbColor() {
        return this.thumbColor;
    }

    public void setThumbColor(Color color) {
        this.thumbColor = color;
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        this.model.removeChangeListener(this.lstnr);
        this.model = boundedRangeModel;
        this.model.addChangeListener(this.lstnr);
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireChangeEvent() {
        this.repaint();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(this.changeEvent);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 0) {
            return new Dimension(16, 300);
        }
        return new Dimension(300, 16);
    }

    protected void customPaint(Graphics2D graphics2D, int n, int n2) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        int n = (int)rectangle.getWidth() - 1;
        int n2 = (int)rectangle.getHeight() - 1;
        int n3 = this.toScreen(this.getLowValue());
        int n4 = this.toScreen(this.getHighValue());
        if (this.empty) {
            if (this.direction == 0) {
                n3 = 16;
                n4 = this.orientation == 0 ? n2 - 16 : n - 16;
            } else {
                n3 = this.orientation == 0 ? n2 - 16 : n - 16;
                n4 = 16;
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(this.getForeground());
        graphics2D.drawRect(0, 0, n, n2);
        this.customPaint(graphics2D, n, n2);
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (this.orientation == 0) {
            if (this.direction == 0) {
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(0, n3 - 16, n, 15);
                this.paint3DRectLighting(graphics2D, 0, n3 - 16, n, 15);
                if (this.thumbColor != null) {
                    graphics2D.setColor(this.thumbColor);
                    graphics2D.fillRect(0, n3, n, n4 - n3 - 1);
                    this.paint3DRectLighting(graphics2D, 0, n3, n, n4 - n3 - 1);
                }
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(0, n4, n, 15);
                this.paint3DRectLighting(graphics2D, 0, n4, n, 15);
                graphics2D.setColor(Color.black);
                this.paintArrow(graphics2D, (double)(n - 8) / 2.0, (double)(n3 - 16) + 6.0, 8, 4, true);
                this.paintArrow(graphics2D, (double)(n - 8) / 2.0, (double)n4 + 6.0, 8, 4, false);
            } else {
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(0, n3, n, 15);
                this.paint3DRectLighting(graphics2D, 0, n3, n, 15);
                if (this.thumbColor != null) {
                    graphics2D.setColor(this.thumbColor);
                    graphics2D.fillRect(0, n4, n, n3 - n4 - 1);
                    this.paint3DRectLighting(graphics2D, 0, n4, n, n3 - n4 - 1);
                }
                graphics2D.setColor(this.getForeground());
                graphics2D.fillRect(0, n4 - 16, n, 15);
                this.paint3DRectLighting(graphics2D, 0, n4 - 16, n, 15);
                graphics2D.setColor(Color.black);
                this.paintArrow(graphics2D, (double)(n - 8) / 2.0, (double)n3 + 6.0, 8, 4, false);
                this.paintArrow(graphics2D, (double)(n - 8) / 2.0, (double)(n4 - 16) + 6.0, 8, 4, true);
            }
        } else if (this.direction == 0) {
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n3 - 16, 0, 15, n2);
            this.paint3DRectLighting(graphics2D, n3 - 16, 0, 15, n2);
            if (this.thumbColor != null) {
                graphics2D.setColor(this.thumbColor);
                graphics2D.fillRect(n3, 0, n4 - n3 - 1, n2);
                this.paint3DRectLighting(graphics2D, n3, 0, n4 - n3 - 1, n2);
            }
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n4, 0, 15, n2);
            this.paint3DRectLighting(graphics2D, n4, 0, 15, n2);
            graphics2D.setColor(Color.black);
            this.paintArrow(graphics2D, (double)(n3 - 16) + 6.0, (double)(n2 - 8) / 2.0, 4, 8, true);
            this.paintArrow(graphics2D, (double)n4 + 6.0, (double)(n2 - 8) / 2.0, 4, 8, false);
        } else {
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n3, 0, 15, n2);
            this.paint3DRectLighting(graphics2D, n3, 0, 15, n2);
            if (this.thumbColor != null) {
                graphics2D.setColor(this.thumbColor);
                graphics2D.fillRect(n4, 0, n3 - n4 - 1, n2);
                this.paint3DRectLighting(graphics2D, n4, 0, n3 - n4 - 1, n2);
            }
            graphics2D.setColor(this.getForeground());
            graphics2D.fillRect(n4 - 16, 0, 15, n2);
            this.paint3DRectLighting(graphics2D, n4 - 16, 0, 15, n2);
            graphics2D.setColor(Color.black);
            this.paintArrow(graphics2D, (double)n3 + 6.0, (double)(n2 - 8) / 2.0, 4, 8, true);
            this.paintArrow(graphics2D, (double)(n4 - 16) + 6.0, (double)(n2 - 8) / 2.0, 4, 8, false);
        }
    }

    protected void paintArrow(Graphics2D graphics2D, double d, double d2, int n, int n2, boolean bl) {
        int n3 = (int)(d + 0.5);
        int n4 = (int)(d2 + 0.5);
        if (this.orientation == 0) {
            if (n % 2 == 0) {
                --n;
            }
            if (bl) {
                for (int i = 0; i < n / 2 + 1; ++i) {
                    graphics2D.drawLine(n3 + i, n4 + i, n3 + n - i - 1, n4 + i);
                }
            } else {
                for (int i = 0; i < n / 2 + 1; ++i) {
                    graphics2D.drawLine(n3 + n / 2 - i, n4 + i, n3 + n - n / 2 + i - 1, n4 + i);
                }
            }
        } else {
            if (n2 % 2 == 0) {
                --n2;
            }
            if (bl) {
                for (int i = 0; i < n2 / 2 + 1; ++i) {
                    graphics2D.drawLine(n3 + i, n4 + i, n3 + i, n4 + n2 - i - 1);
                }
            } else {
                for (int i = 0; i < n2 / 2 + 1; ++i) {
                    graphics2D.drawLine(n3 + i, n4 + n2 / 2 - i, n3 + i, n4 + n2 - n2 / 2 + i - 1);
                }
            }
        }
    }

    protected void paint3DRectLighting(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
        graphics2D.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
    }

    protected int toLocal(int n) {
        Dimension dimension = this.getSize();
        int n2 = this.getMinimum();
        double d = this.orientation == 0 ? (double)(dimension.height - 32) / (double)(this.getMaximum() - n2) : (double)(dimension.width - 32) / (double)(this.getMaximum() - n2);
        if (this.direction == 0) {
            return (int)((double)(n - 16) / d + (double)n2 + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)(dimension.height - n - 16) / d + (double)n2 + 0.5);
        }
        return (int)((double)(dimension.width - n - 16) / d + (double)n2 + 0.5);
    }

    protected int toScreen(int n) {
        Dimension dimension = this.getSize();
        int n2 = this.getMinimum();
        double d = this.orientation == 0 ? (double)(dimension.height - 32) / (double)(this.getMaximum() - n2) : (double)(dimension.width - 32) / (double)(this.getMaximum() - n2);
        if (this.direction == 0) {
            return (int)(16.0 + (double)(n - n2) * d + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)dimension.height - (double)(n - n2) * d - 16.0 + 0.5);
        }
        return (int)((double)dimension.width - (double)(n - n2) * d - 16.0 + 0.5);
    }

    protected double toScreenDouble(int n) {
        Dimension dimension = this.getSize();
        int n2 = this.getMinimum();
        double d = this.orientation == 0 ? (double)(dimension.height - 32) / (double)(this.getMaximum() + 1 - n2) : (double)(dimension.width - 32) / (double)(this.getMaximum() + 1 - n2);
        if (this.direction == 0) {
            return 16.0 + (double)(n - n2) * d;
        }
        if (this.orientation == 0) {
            return (double)dimension.height - (double)(n - n2) * d - 16.0;
        }
        return (double)dimension.width - (double)(n - n2) * d - 16.0;
    }

    private int pickHandle(int n) {
        int n2 = this.toScreen(this.getLowValue());
        int n3 = this.toScreen(this.getHighValue());
        int n4 = 0;
        if (this.direction == 0) {
            if (n > n2 - 16 && n < n2) {
                n4 = 1;
            } else if (n >= n2 && n <= n3) {
                n4 = 2;
            } else if (n > n3 && n < n3 + 16) {
                n4 = 3;
            }
        } else if (n > n2 && n < n2 + 16) {
            n4 = 1;
        } else if (n <= n2 && n >= n3) {
            n4 = 2;
        } else if (n > n3 - 16 && n < n3) {
            n4 = 3;
        }
        return n4;
    }

    private void offset(int n) {
        this.model.setValue(this.model.getValue() + n);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.orientation == 0) {
            this.pick = this.pickHandle(mouseEvent.getY());
            this.pickOffsetLow = mouseEvent.getY() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = mouseEvent.getY() - this.toScreen(this.getHighValue());
            this.mouse = mouseEvent.getY();
        } else {
            this.pick = this.pickHandle(mouseEvent.getX());
            this.pickOffsetLow = mouseEvent.getX() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = mouseEvent.getX() - this.toScreen(this.getHighValue());
            this.mouse = mouseEvent.getX();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.requestFocus();
        int n = this.orientation == 0 ? mouseEvent.getY() : mouseEvent.getX();
        int n2 = this.getMinimum();
        int n3 = this.getMaximum();
        int n4 = this.getLowValue();
        int n5 = this.getHighValue();
        switch (this.pick) {
            case 1: {
                int n6 = this.toLocal(n - this.pickOffsetLow);
                if (n6 < n2) {
                    n6 = n2;
                }
                if (n6 > n3 - this.minExtent) {
                    n6 = n3 - this.minExtent;
                }
                if (n6 > n5 - this.minExtent) {
                    this.setRange(n6, n6 + this.minExtent);
                    break;
                }
                this.setLowValue(n6);
                break;
            }
            case 3: {
                int n7 = this.toLocal(n - this.pickOffsetHigh);
                if (n7 < n2 + this.minExtent) {
                    n7 = n2 + this.minExtent;
                }
                if (n7 > n3) {
                    n7 = n3;
                }
                if (n7 < n4 + this.minExtent) {
                    this.setRange(n7 - this.minExtent, n7);
                    break;
                }
                this.setHighValue(n7);
                break;
            }
            case 2: {
                int n8 = this.toLocal(n - this.pickOffsetLow) - n4;
                if (n8 < 0 && n4 + n8 < n2) {
                    n8 = n2 - n4;
                }
                if (n8 > 0 && n5 + n8 > n3) {
                    n8 = n3 - n5;
                }
                if (n8 == 0) break;
                this.offset(n8);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.pick = 0;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.orientation == 0) {
            switch (this.pickHandle(mouseEvent.getY())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            switch (this.pickHandle(mouseEvent.getX())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void grow(int n) {
        this.model.setRangeProperties(this.model.getValue() - n, this.model.getExtent() + 2 * n, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = this.orientation == 0;
        boolean bl2 = n == 40;
        boolean bl3 = n == 38;
        boolean bl4 = n == 37;
        boolean bl5 = n == 39;
        int n2 = this.getMinimum();
        int n3 = this.getMaximum();
        int n4 = this.getLowValue();
        int n5 = this.getHighValue();
        if (bl && bl5 || !bl && bl3) {
            if (n4 - this.increment >= n2 && n5 + this.increment <= n3) {
                this.grow(this.increment);
            }
        } else if (bl && bl4 || !bl && bl2) {
            if (n5 - n4 >= 2 * this.increment) {
                this.grow(-1 * this.increment);
            }
        } else if (bl && bl2 || !bl && bl4) {
            if (n4 - this.increment >= n2) {
                this.offset(-this.increment);
            }
        } else if ((bl && bl3 || !bl && bl5) && n5 + this.increment <= n3) {
            this.offset(this.increment);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected class RangeSliderChangeListener
    implements ChangeListener {
        protected RangeSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JRangeSlider.this.fireChangeEvent();
        }
    }
}

